/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/repairer/enabler/DefaultNaming.java,v 1.2 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer.enabler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultNaming implements Naming {
    /** max number of resources placed in one folder */
    public final int folderMax;
    
    /**
     * Number of names generated for various doctypes. Maps doctypes to Integere objects
     */
    private Map counters;
    
    public DefaultNaming() {
        this(5000);
    }
    
    public DefaultNaming(int folderMax) {
        this.folderMax = folderMax;
        this.counters = new HashMap();
    }
    
    public String getName(Document document) {
        String doctype;
        String folder;
        String name;
        String ext;
        
        doctype = replaceSpecial(document.getDoctype());
        folder = "folder" + (incCounter(doctype) / folderMax);
        name = "/" + doctype + "/" + folder + "/" + base(document);
        ext = ext(document);
        if (!name.toLowerCase().endsWith(ext.toLowerCase())) {
            name = name + ext;
        }
        return name;
    }
    
    private static String base(Document document) {
        String docname;
        
        docname = document.getTaminoDocname();
        if( docname != null && !"".equals(docname) ) {
            return docname;
        } else {
            return "document" + document.getTaminoId();
        }
    }
    
    private static String ext(Document resource) {
        List tmp;
        
        tmp = resource.getMimeExtensions();
        if (tmp.isEmpty()) {
            return "";
        } else {
            return "." + (String) tmp.get(0);
        }
    }
    
    private static String replaceSpecial(String str) {
        return str.replace(':', '_');
    }
    
    private static final Integer ZERO = new Integer(0);
    
    private int incCounter(String schema) {
        Integer oldCount;
        int newCount;
        
        oldCount = (Integer) counters.get(schema);
        if (oldCount == null) {
            oldCount = ZERO;
        }
        newCount = oldCount.intValue() + 1;
        counters.put(schema, new Integer(newCount));
        return newCount;
    }
}
