/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/Parameter.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.stores;




/**
 ** Kind of a hashmap that preserves the order and has to/from xml methods.
 **
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 */
public class Parameter {
    private final String name;
    private final String dflt;
    
    public Parameter(String name, boolean dflt) {
        this(name, "" + dflt);
    }
    
    public Parameter(String name, String dflt) {
        this.name = name;
        this.dflt = dflt;
    }

    public String getString(Parameters parms) {
        return parms.get(name, dflt);
    }

    public void setString(Parameters parms, String value) {
        parms.set(name, value);
    }

    public void setStringOpt(Parameters parms, String value) {
        if (value != null) {
            setString(parms, value);
        }
    }
    
    /**
     ** Every string other than "true" is considered false. In particular, a null default string
     ** is considered false.
     **/
    public boolean getBoolean( Parameters parms ) {
        return "true".equalsIgnoreCase(getString(parms));
    }
    
    public void setBoolean(Parameters parms, boolean value) {
        setString(parms, ""+value);
    }
    
    public static void initialize(Parameters result, Parameter[] parms) {
        int i;
        Parameter p;
        
        for (i = 0; i < parms.length; i++) {
            p = parms[i];
            result.set(p.name, p.dflt);
        }
    }
}

