/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/Takeover.java,v 1.1 2004/03/25 16:18:06 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.store.tamino.tools.Command;
import org.apache.slide.store.tamino.tools.Output;
import org.apache.slide.store.tamino.tools.stores.XDomainFileHandler;
import org.apache.slide.util.JDom;
import org.apache.slide.util.XException;
import org.apache.slide.util.cli.Abort;
import org.xml.sax.InputSource;

public class Takeover extends Command {
    private final PrintStream verbose;
    private final XDomainFileHandler toDfh;
    private final String store;
    private final String fromDomainXml;
    private final String namespace;
    private final boolean overwrite;
    
    public Takeover(Output out, XDomainFileHandler toDfh, String fromDomainXml, String namespace, String store, boolean overwrite)
        throws Abort {
        super("takeover stores", out);
        
        if( fromDomainXml == null || fromDomainXml.length() == 0 ) {
            throw new Abort("Missing fromDomainFile");
        }
        this.verbose = out.verbose;
        this.toDfh = toDfh;
        this.fromDomainXml = fromDomainXml;
        this.namespace = namespace;
        this.store = store;
        this.overwrite = overwrite;
    }
    
    public void run() throws XException {
        XDomainFileHandler fromDfh;
        List toList;
        List fromList;
        List done;
        Iterator iter;
        String from;
        String cfg;
        InputSource src;

        fromDfh = XDomainFileHandler.create(fromDomainXml);
        toList = toDfh.getDomain().getNamespace(namespace).getPublicStoreGroupNames();
        if (store != null && store.length() > 0) {
            fromList = new ArrayList();
            fromList.add(store);
        } else {
            fromList = fromDfh.getDomain().getNamespace(namespace).getPublicStoreGroupNames();
        }
        done = new ArrayList();
        iter = fromList.iterator();
        while (iter.hasNext()) {
            from = (String) iter.next();
            if (!toList.contains(from) || overwrite) {
                cfg = JDom.toString(fromDfh.getStoreConfig(namespace, from));
                try {
                    src = new InputSource(new ByteArrayInputStream(cfg.getBytes(JDom.UTF_8)));
                } catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException();
                }
                src.setSystemId(fromDomainXml); // needed to resolve relative system ids
                toDfh.setStoreConfig(namespace, from, src);
                done.add(from);
            }
        }
        toDfh.save();
        verbose.println( "\n"+done.size()+" stores have been taken-over successfully from \""+
                            fromDomainXml + "\": " + done );
    }
}

