/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/WriteCommand.java,v 1.1 2004/03/25 16:18:06 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.tools.Command;
import org.apache.slide.store.tamino.tools.Output;
import org.apache.slide.store.tamino.tools.stores.XDomain;
import org.apache.slide.store.tamino.tools.stores.XNamespace;
import org.apache.slide.store.tamino.tools.stores.XStoreGroupTypeList;
import org.apache.slide.util.JDom;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;
import org.apache.slide.util.cli.Abort;
import org.jdom.Document;

public class WriteCommand extends Command {
    public static WriteCommand global(final XDomainFileHandler dfh, File dir, Output out) {
        return new WriteCommand("get global parameters", out, dfh.getGlobalConfig(),
                                dir, XGlobals.DELTAV_GLOBAL_PARMS_FILENAME);
    }
    
    public static WriteCommand store(final XDomainFileHandler dfh, final String namespace,
                                     final String store, File dir, Output out)
        throws XException
    {
        return new WriteCommand("get store " + store + " from namespace '" + namespace + "'", out,
                                dfh.getStoreConfig(namespace, store), dir, store);
    }
    
    public static WriteCommand newDomain(Output out, final String namespace, File dir)
        throws XException
    {
        XStoreGroupTypeList groupTypes;
        XNamespace ns;
        XDomain domain;
        
        domain = XDomain.create();
        groupTypes = domain.getConfig().createTypes();
        ns = new XNamespace(namespace);
        ns.addStoreGroup(groupTypes.xdavOther.create(XNamespace.XDAV_GROUP_NAME));
        ns.addStoreGroup(groupTypes.secUrm.create(XNamespace.SECURITY_GROUP_NAME));
        domain.addNamespace(ns);
        return new WriteCommand("get new domain file with namespace '" + namespace + "'", out,
                                new Document(domain.toXml()), dir, XGlobals.DOMAIN);
    }
    
    public static WriteCommand newStore(Output out, final String namespace, final String store, File dir)
        throws Abort
    {
        XStoreGroupTypeList groupTypes;
        Object[] tmp;
        
        groupTypes = XDomain.create().getConfig().createTypes();
        tmp = StoreCommands.createStoreConfig(namespace, groupTypes, "http://localhost/tamino/mydb/" + store );
        return new WriteCommand("get new store", out, (Document) tmp[1], dir, store);
    }
    
    //--
    
    private final File file;
    private final Document doc;
    
    private WriteCommand(String name, Output out, Document doc, File dir, String filename) {
        super(name, out);
        this.doc = doc;
        if (dir == null) {
            this.file = null;
        } else {
            this.file = new File(dir, filename + XUri.XML_SUFF);
        }
    }
    
    public void run() throws IOException, XException {
        FileOutputStream dest;
        String str;
        
        str = JDom.toString(doc);
        if (file != null) {
            out.normal.println("writing " + file);
            dest = new FileOutputStream(file);
            JDom.print(str, dest);
            dest.close();
        } else {
            out.quiet.println(str);
        }
    }
}

