/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XDomainConstants.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import org.apache.slide.util.Misc;
import org.apache.slide.util.PublicIdResolver;

/**
 ** String constants.
 **
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public interface XDomainConstants {
    String
        CLAZZNAME                           = "classname",
        CONFIGURATION                       = "configuration",
        CONFIG_DTD                          = "../etc/" + PublicIdResolver.CONFIG_DTD_FILENAME,
        CONFIG_DTD2                         = "../../etc/" + PublicIdResolver.CONFIG_DTD_FILENAME,
        DATA                                = "data",
        DEFINITION                          = "definition",
        DELTAV_STORE_PREFIX                 = "$deltav",
        ETC                                 = "etc",
        FILESTORE                           = "slidestore.reference.FileContentStore",  // TODO: .class.getName()
        MATCH                               = "match",
        NAME                                = "name",
        NAMESPACE                           = "namespace",
        OBJECTNODE                          = "objectnode",
        REFERENCE                           = "reference",
        RESOURCE_PREFIX                     = Misc.getPackageResourceName(XDomainConstants.class) + "/",
        SCOPE                               = "scope",
        STORE                               = "store",
        TYPE                                = "type",
        URI                                 = "uri",
        
        EOF_DUMMY                           = "@";
}

