/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XNamePattern.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

/**
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 **/
import org.apache.slide.util.Pattern;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XUri;

public class XNamePattern {
    public static XNamePattern create(String pattern, String groupName, Pattern scopePattern) {
        final String START = "${";
        final String VARIABLE = START + "scope" + "}";
        int idx;
        
        idx = pattern.indexOf(START);
        if (idx == -1) {
            return new XNamePattern(pattern, null, groupName, scopePattern);
        }
        if (idx != pattern.indexOf(VARIABLE)) {
            throw new XAssertionFailed("illegal pattern parameter, pattern=" + pattern);
        }
        return new XNamePattern(pattern.substring(0, idx),
                                pattern.substring(idx + VARIABLE.length()), groupName, scopePattern);
    }
    
    //--
    
    private final String prefix;
    
    /** null if not parameterized */
    private final String suffix;
    
    private final String groupName;
    
    private final Pattern scopePattern;
    
    public XNamePattern(String prefix, String suffix, String groupName, Pattern scopePattern) {
        if (suffix == null) {
            if (groupName == null) {
                throw new XAssertionFailed("missing groupName");
            }
        } else {
            if (groupName != null) {
                throw new XAssertionFailed("unexpected groupName: " + groupName);
            }
        }
        
        this.prefix = prefix;
        this.suffix = suffix;
        this.groupName = groupName;
        this.scopePattern = scopePattern;
    }
    
    public String toString() {
        return "XNamePattern(prefix=" + prefix + ", suffix=" + suffix +
            ", groupName=" + groupName + ", scopePattern=" + scopePattern + ")";
    }
    
    /**
     * @return scopeGroupName or null if not matched
     */
    public String matches(XStore store) {
        return matches(store.getName(), store.getScope());
    }
    
    public String matches(String storeName, XUri actualScopeUri) {
        String groupNameRaw;
        
        if (!storeName.equals(createName(actualScopeUri))) {
            return null;
        }
        if (scopePattern.match(actualScopeUri.toString()) == null) {
            return null;
        }
        if (suffix == null) {
            return groupName;
        } else {
            groupNameRaw = storeName.substring(prefix.length(), storeName.length() - suffix.length());
            if (scopePattern.isParameterized()) {
                return scopePattern.match(actualScopeUri.toString());
            } else {
                return groupNameRaw;
            }
        }
    }
    
    public XUri getScope(String groupName) {
        return new XUri(scopePattern.resolve(groupName));
    }
    
    public String createName(XUri scope) {
        if (suffix == null) {
            return prefix;
        } else {
            return prefix + scopeToNameInfix(scope) + suffix;
        }
    }
    
    private static String scopeToNameInfix(XUri scope) {
        return scope.toString().substring(1).replace('/', '_');
    }
}

