/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XNamespaceConfig.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.tools.stores;

import org.apache.slide.store.tamino.security.URMSecurityImpl;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.XException;
import org.jdom.Element;

/**
 ** XNamespaceConfig.java.
 **
 ** @author michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/

public class XNamespaceConfig {
    private static final String USERS                   = "users";
    private static final String GROUPS                  = "groups";
    private static final String ROLES                   = "roles";

    public static final Parameter DAV = new Parameter("dav", true);
    public static final Parameter STANDALONE = new Parameter("standalone", true);
    public static final Parameter XDAV_ADMIN_USER = new Parameter("xdavAdminUser", "inodavuser");
    public static final Parameter XDAV_ADMIN_PWD = new Parameter("xdavAdminPwd", "tws");
    public static final Parameter XDAV_ADMIN_DOMAIN = new Parameter("xdavAdminDomain", "");
    public static final Parameter ACL_SEMANTICS = new Parameter("acl_semantics", URMSecurityImpl.class.getName());
    public static final Parameter ACL_INHERITANCE_TYPE = new Parameter("acl_inheritance_type", "path");

    public static XNamespaceConfig create() {
        Element root;
        
        root = new Element("foo");
        try {
            return XNamespaceConfig.extractFromXml(root);
        } catch (XException e) {
            throw new XAssertionFailed(e);
        }
    }
    
    //--
    
    private boolean dav;
    private boolean standalone;
    
    private String adminUser;
    private String adminPwd;
    private String adminDomain;
    
    private String aclSemantics;
    private String aclInheritanceType;
    
    public XNamespaceConfig(boolean dav, boolean standalone,
                            String adminUser, String adminPwd, String adminDomain,
                            String aclSemantics, String aclInheritanceType)
    {
        this.dav = dav;
        this.standalone = standalone;
        this.adminUser = adminUser;
        this.adminPwd = adminPwd;
        this.adminDomain = adminDomain;
        this.aclSemantics = aclSemantics;
        this.aclInheritanceType = aclInheritanceType;
    }
    
    public boolean equals(Object obj) {
        // TODO: isn't there a Java-way to compare all fields?
        XNamespaceConfig nc;
        
        if (obj instanceof XNamespaceConfig) {
            nc = (XNamespaceConfig) obj;
            return dav == nc.dav && standalone == nc.standalone
                && eq(adminUser, nc.adminUser)
                && eq(adminPwd, nc.adminPwd)
                && eq(adminDomain, nc.adminDomain)
                && eq(aclSemantics, nc.aclSemantics)
                && eq(aclInheritanceType, nc.aclInheritanceType);
        } else {
            return false;
        }
    }

    private static boolean eq(String left, String right) {
        if (left == null) {
            return right == null;
        } else {
            return left.equals(right);
        }
    }
    
    public String getAdminUser() {
        return adminUser;
    }
    
    public String getAdminPwd() {
        return adminPwd;
    }
    
    public String getAdminDomain() {
        return adminDomain;
    }

    //-- xml stuff
    
    public static XNamespaceConfig extractFromXml(Element config) throws XException {
        Parameters parms;
        
        parms = Parameters.fromXml(config);
        Parameters.removeFromXml(config);
        // TODO: complain about unused parameter
        return new XNamespaceConfig(
            DAV.getBoolean(parms),
            STANDALONE.getBoolean(parms),
            XDAV_ADMIN_USER.getString(parms),
            XDAV_ADMIN_PWD.getString(parms),
            XDAV_ADMIN_DOMAIN.getString(parms),
            ACL_SEMANTICS.getString(parms),
            ACL_INHERITANCE_TYPE.getString(parms)
        );
    }

    public void addXml(Element root) {
        
        Parameters parms;
        
        parms = new Parameters();
        DAV.setBoolean(parms, dav);
        STANDALONE.setBoolean(parms, standalone);
        XDAV_ADMIN_USER.setString(parms, adminUser);
        XDAV_ADMIN_PWD.setString(parms, adminPwd);
        XDAV_ADMIN_DOMAIN.setString(parms, adminDomain);
        ACL_SEMANTICS.setStringOpt(parms, aclSemantics);
        ACL_INHERITANCE_TYPE.setString(parms, aclInheritanceType);

        parms.addXml(root);
    }
}

