/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XObjectnode.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.stores;


import java.util.Iterator;
import org.apache.slide.util.JDom;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;
import org.jdom.Element;

/**
 ** Represents a data section.
 **
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 **/
public class XObjectnode {
    public static void removeRecursive(Element element) {
        Element parent;
        
        while (true) {
            parent = (Element) element.getParent();
            if (parent.getName().equals(XDomainConstants.DATA)) {
                return;
            }
            parent.getContent().remove(element);
            if (parent.getChildren(XDomainConstants.OBJECTNODE).size() > 0) {
                return;
            }
            element = parent;
        }
    }
    
    /**
     ** @param createClassName  != null to create node with the specified class
     ** @return null if not found
     **/
    public static Element locate(XUri uri, Element data, String createClassName) throws XException {
        Element root;
        int max;
        int i;
        Element next;
        
        root = data;
        max = uri.size();
        for (i = 0; i <= max; i++) {
            next = getNext(root, uri.suburi(0, i));
            if (next == null) {
                break;
            }
            root = next;
        }

        if (createClassName != null) {
            if (i == max + 1) {
                throw new XException("objectnode exists: " + uri);
            }

            for ( ; i <= max; i++) {
                next = new Element( XDomainConstants.OBJECTNODE );
                // TODO: createClassName also used for intermediate nodes
                next.setAttribute( XDomainConstants.CLAZZNAME, createClassName);
                next.setAttribute( XDomainConstants.URI, uri.suburi(0, i).toString() );

                root.addContent( next );
                root = next;
            }
        } else {
            if (i != max + 1) {
                return null;
            }
        }

        return root;
    }
    
    private static Element getNext(Element parent, XUri uri) throws XException {
        Iterator iter;
        Element next;
        XUri u;
        Element found;
        
        iter = parent.getChildren( XDomainConstants.OBJECTNODE ).iterator();
        found = null;
        while( iter.hasNext() ) {
            next = (Element)iter.next();
            u = getUri(next);
            if (u.equals(uri)) {
                if (found != null) {
                    throw new XException("ambiguous scope: " + uri);
                }
                found = next;
            }
        }
        return found;
    }
    
    private static XUri getUri(Element next) throws XException {
        return new XUri(JDom.getAttribute(next, XDomainConstants.URI ));
    }
}

