/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XStoreGroupType.java,v 1.3 2004/07/30 06:52:06 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import org.apache.slide.store.tamino.tools.stores.XStoreGroup;
import java.util.ArrayList;
import java.util.List;

/**
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 **/
public class XStoreGroupType {
    public final String name;
    public final boolean internal;
    public final XStoreType[] types;

    public XStoreGroupType(String name, XStoreTypeList types) {
        this(name, false, new XStoreType[] {
            types.userNormal, types.userHistory, types.userWorkspace, types.userWorkingResource
        });
    }
    
    public XStoreGroupType(String name, boolean internal, XStoreType[] storeTypes) {
        this.name = name;
        this.internal = internal;
        this.types = storeTypes;
    }
    
    /** Name as specified in config.xml's type attribute **/
    public String getName() {
        return name;
    }
    
    public XStoreGroup create(String groupName) {
        XStore[] stores;
        int i;
        
        stores = new XStore[types.length];
        for (i = 0; i < stores.length; i++) {
            stores[i] = types[i].create(groupName);
        }
        return new XStoreGroup(internal, groupName, this, stores);
    }
    
    public XStore[] extract(List storeListOrig) {
        List storeList;
        int i;
        XStore p;
        XStore[] result;

        storeList = new ArrayList(storeListOrig);
        result = new XStore[types.length];
        for (i = 0; i < types.length; i++) {
            p = types[i].extract(storeList);
            if (p == null) {
                return null;
            }
            result[i] = p;
        }
        return result;
    }
}

