/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XStoreGroupTypeList.java,v 1.3 2004/07/30 06:52:07 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:07 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.util.List;
import org.apache.slide.store.tamino.tools.stores.XStoreGroup;
import org.apache.slide.util.XException;

/**
 ** TODO: unified prefixes
 **
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 **/
public class XStoreGroupTypeList {
    public final XStoreGroupType userTamino;
    public final XStoreGroupType userTxFile;
    public final XStoreGroupType userFile;
    
    public final XStoreGroupType secUrm;

    // TODO: dump this - used secNoUrm
    
    public final XStoreGroupType xdavOther;

    private final XStoreGroupType[] all;

    //--
    
    private static final String SEC_NAME = "security";
    private static final String XDAV_NAME = "xdav";
    
    public final XStoreTypeList types;
    
    public XStoreGroupTypeList(XStoreTypeList types) {
        this.types = types;
        
        userTamino = new XStoreGroupType("tamino", types);
        userTxFile = new XStoreGroupType("txfile", true, new XStoreType[] {
            types.txFile
        });
        userFile = new XStoreGroupType("file", types); // TODO: wrong aspects

        secUrm = new XStoreGroupType(SEC_NAME, true, new XStoreType[] {
            types.secUrmUserdb, types.secUrmUsers, types.secUrmGroups, types.secUrmRoles
        });

        xdavOther = new XStoreGroupType(XDAV_NAME, true, new XStoreType[] {
            types.xdavDefault,
            types.xdavStatistics,
            types.xdavSecurity,
            types.xdavActions,
            types.xdavConfiguration,
            types.xdavEtc,
            types.xdavRepairer,
            types.xdavSchema
        });

        all = new XStoreGroupType[] {
            // CAUTION: keep secUrm before secNoUrm -- noUrm is a subset that would otherwise
            // always be recognized
            userTamino, userTxFile, userFile, secUrm, xdavOther
        };
    }
    
    //--
    
    public XStoreGroup probe(String groupName, List storeList) throws XException {
        int i;
        XStoreGroupType t;
        XStore[] stores;
        
        for (i = 0; i < all.length; i++) {
            t = all[i];
            stores = t.extract(storeList);
            if (stores != null) {
                return new XStoreGroup(t.internal, groupName, t, stores);
            }
        }
        return null;
    }
    
    public XStoreGroupType lookup(String name) throws XException {
        int i;
        XStoreGroupType t;
        
        for (i = 0; i < all.length; i++) {
            t = all[i];
            if (t.name.equals(name)) {
                return t;
            }
        }
        throw new XException("unkown store type: " + name);
    }
}


