/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/tools/stores/XStoreType.java,v 1.3 2004/07/30 06:52:07 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:07 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import java.util.Iterator;
import java.util.List;
import org.apache.slide.util.Pattern;
import org.apache.slide.util.XUri;

/**
 ** @author michael.hartmeier@softwareag.com
 ** @version $Revision: 1.3 $
 **/

public class XStoreType {
    /** Unique name for this type; used to assign parameter specific for this store **/
    public final String name;
    
    private final String parentStoreClass;
    private final XStoreAspects aspects;
    
    /** used by create **/
    private final Parameter[] paras;
    
    private final XNamePattern namePattern;
    private final String objectNodeClass;
    private final List xmlData;
    
    public XStoreType(String name, Pattern scopePattern, String groupName, String storeNamePattern,
                       String parentStoreClass, XStoreAspects aspects, Parameter[] paras,
                       String objectNodeClass, List xmlData) {
        this.name = name;
        this.parentStoreClass = parentStoreClass;
        this.aspects = aspects;
        this.paras = paras;
        this.objectNodeClass = objectNodeClass;
        this.xmlData = xmlData;
        this.namePattern = XNamePattern.create(storeNamePattern, groupName, scopePattern);
    }
    
    public XStore create(String groupName) {
        Parameters values;
        XStore store;
        XUri scopeUri;
        String storeName;
        
        values = new Parameters();
        Parameter.initialize(values, paras);
        scopeUri = namePattern.getScope(groupName);
        storeName = namePattern.createName(scopeUri);
        store = new XStore(storeName, parentStoreClass, getAspectInstance(storeName), values, scopeUri);
        store.setObjectData(objectNodeClass, xmlData.iterator());
        return store;
    }

    private XStoreAspects getAspectInstance(String storeName) {
        XStoreAspects a;

        a = new XStoreAspects(aspects);
        a.substitue(storeName);
        return a;
    }
    
    public XStore extract(List lst) {
        XStore p;
        Iterator iter;
        
        iter = lst.iterator();
        while (iter.hasNext()) {
            p = (XStore) iter.next();
            if (isInstance(p)) {
                iter.remove();
                return p;
            }
        }
        return null;
    }

    public boolean isInstance(XStore store) {
        return namePattern.matches(store) != null
            && parentStoreClass.equals(store.getParentStoreClass())
            && aspects.equalsRaw(store.getAspects());
    }

    public XNamePattern getNamePattern() {
        return namePattern;
    }
}

