/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/URMException.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm;

import org.apache.log4j.Logger;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;

/**
 * The root exception class for each URM exception class.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMException extends Exception {
    // original thrown and now wrapped exception or error
    private Throwable throwable = null;
 
    /** creates a new SAGException
     */
    public URMException() {
        super();
    }
    
    /** creates new URMException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMException(Throwable e) {
        super(e.getMessage(), e);
        
        throwable = e;
    }
    
    /** creates new URMException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMException(Logger logger, String level, Throwable e) {
        super(e);
        MessageLogger.logMessage(logger, level, e);

        throwable = e;
    }
    
    /** creates new URMException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMException(URMException e) {
        super(e);
        
        throwable = e.getThrowable();
    }
    
    /** creates new URMException
     *
     * @param msg Message that should be shown with this exception
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMException(String msg, Throwable e) {
        super(msg, e);
        
        throwable = e;
    }
    
    /** creates a new URMException
     *
     * @param msg Message that should be shown with this exception
     */
    public URMException(String msg) {
        super(msg);
    }
    
    /** Prints the stacktrace of the original exception together with the stacktrace
     * of this exception.
     */
    public void printFullStackTrace() {
        if (throwable != null) throwable.printStackTrace();
        this.printStackTrace();
    }
    
    /** Returns the message of the wrapped exception, if no exception is wrapped
     *  null is returned.
     *
     *  @return String, exception message of origninal exception, null else.
     */
    public String getInternalMessage() {
        if (throwable != null) {
            return throwable.getMessage();
        } else {
            return null;
        }
    }
    
    /** returns the wrapped exception, if no exception is wrapped
     *  null is returned
     *
     *  @return Throwable, origninal exception, null else.
     */
    public Throwable getThrowable() {
        return throwable;
    }

}
