/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAccessCheckException.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import org.apache.slide.urm.URMException;
import org.apache.log4j.Logger;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;

/**
 * Exception class to throw it when the access check fails.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMAccessCheckException extends URMException {
    // original thrown and now wrapped exception or error
    private Throwable throwable = null;
 
    /** creates a new SAGException
     */
    public URMAccessCheckException() {
        super();
    }
    
    /** creates new URMAclException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMAccessCheckException(Throwable e) {
        super(e.getMessage(), e);
        
        throwable = e;
    }
    
    /** creates new URMAclException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMAccessCheckException(Logger logger, String level, Throwable e) {
        super(e.getMessage(), e);
        MessageLogger.logMessage(logger, level, e);

        throwable = e;
    }
    
    /** creates new URMAclException
     *
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMAccessCheckException(URMException e) {
        super(e.getMessage(), e);
        
        throwable = e.getThrowable();
    }
    
    /** creates new URMAclException
     *
     * @param msg Message that should be shown with this exception
     * @param e exception or error original thrown by the wrapped tool
     */
    public URMAccessCheckException(String msg, Throwable e) {
        super(e.getMessage(), e);
        
        throwable = e;
    }
    
    /** creates a new URMAclException
     *
     * @param msg Message that should be shown with this exception
     */
    public URMAccessCheckException(String msg) {
        super(msg);
    }
    
    /** Prints the stacktrace of the original exception together with the stacktrace
     * of this exception.
     */
    public void printFullStackTrace() {
        if (throwable != null) throwable.printStackTrace();
        this.printStackTrace();
    }
    
    /** Returns the message of the wrapped exception, if no exception is wrapped
     *  null is returned.
     *
     *  @return String, exception message of origninal exception, null else.
     */
    public String getInternalMessage() {
        if (throwable != null) {
            return throwable.getMessage();
        } else {
            return null;
        }
    }
    
    /** returns the wrapped exception, if no exception is wrapped
     *  null is returned
     *
     *  @return Throwable, origninal exception, null else.
     */
    public Throwable getThrowable() {
        return throwable;
    }
}
