/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAccessControlerSpi.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import java.util.List;
import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.authenticator.URMDBTransactionException;
import org.apache.slide.urm.common.URMConnectionException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMAccessControlerSpi {
    
    
    
    /******************* URMAclAdmin methods *************** start ************/

    public abstract URMAcl getAcl(String id) throws URMInternalServerException;


    public abstract List getAclPath(List acls) throws URMInternalServerException;
    

    public abstract String createAcl(String id, String owner, int ownerType,
                            String ownerDomain, boolean inheritable)
        throws URMAclIdNotUniqueException, URMInternalServerException, URMInsertException;


    public abstract void deleteAcl(String acl)
        throws URMInternalServerException, URMDeleteException;
    
    public abstract URMAction createAction(String name)
        throws URMActionIdNotUniqueException, URMInternalServerException, URMInsertException;

    public abstract void deleteAction(String name)
        throws URMActionInUseException, URMInternalServerException, URMDeleteException;

    public abstract URMAction getAction(String name)
        throws URMInternalServerException;
    
    public abstract Set getAllActions()
        throws URMInternalServerException;
        
    /*
     * beginTransaction needs to be present to handle the caches
     */
    public void beginTransaction()
        throws  URMDBTransactionException, URMInternalServerException;
    
    /*
     * endTransaction needs to be present to handle the caches
     */
    public void endTransaction(boolean manner)
        throws  URMDBTransactionException, URMInternalServerException;
    
    /******************* URMAclAdmin methods ******************* end **********/

    public abstract Set getAllActionsAsString()
        throws URMInternalServerException;

    /******************* URMAcl methods ******************** start ************/

    public abstract void setAclInheritable(String aclId, boolean inheritable)
            throws URMInsertException, URMInternalServerException;
    
    public abstract List getAllAces(String aclId) throws URMInternalServerException;
    
    public abstract void updateOrder(String aclId, /*int[] oldIds,*/ int[] newIds)
        throws URMAclException, URMUpdateException, URMInternalServerException;

    public abstract void updateOwner(String aclId, String owner, int ownerType, String domain)
        throws URMUpdateException, URMInternalServerException;

    public abstract List defineAce(String aclId,
                          String resOwner,
                          int resOwnerType,
                          String resDomain,
                          boolean resInherit,
                          int type,
                          String subject,
                          int subjectType,
                          String domain,
                          String action,
                          int position,
                          boolean invert,
                          List list)
                        throws URMUnknownSubjectException,
                               URMUnknownActionException,
                               URMAceCreateException,
                               URMInternalServerException;

//    public abstract void removeAce(String aclId, int aceId)
//            throws URMDeleteException, URMInternalServerException;
    

    public List removeAce (String aclId,
                            String resOwner,
                            int resOwnerType,
                            String resDomain,
                            boolean resInherit,
                            int id,
                            List list) throws URMDeleteException, URMInternalServerException;
    
    /******************* URMAcl methods ************************ end **********/

    
    /******************* URMAction methods ***************** start ************/

    public abstract void removeAction(String name)
            throws URMInternalServerException,
                   URMForbiddenException, URMDeleteException;

    public abstract void addBaseAction(String name, String baseAction)
            throws URMForbiddenException,
                   URMInsertException, URMInternalServerException;

    public abstract void removeBaseAction(String name, String baseAction)
            throws URMDeleteException, URMInternalServerException;
        
    /******************* URMAction methods ********************* end **********/

    /**
     * Helper function to the reporting functions.
     * The input parameter specifies a path ('/' separated) of resource Ids.
     * All ACLs (referenced via the resource Ids) will be inspected.
     * The second input parameter specifies a list of actions.
     * Returned will only the ACLs and ACEs that contain an action, specified
     * in inActions.
     *
     * @param resources List of ACLs in the order they should be validated
     * @param inActions Action names to be identified.
     *
     * @return List of ACLs with only these ACEs that contain one of the inAction
     * parameter.
     *
     * @throws URMInternalServerException
     */
    public abstract List getAclsWithSpecificAction(List resources,
                                             List inActions)
        throws URMInternalServerException;

    public URMAccessControlerSpi duplicateObject(Object owner) throws URMConnectionException;
    
    public void loadActionSetIntoCache(Set actions) throws URMInternalServerException;
    
    /**
     * Signals the cache that an ACL does not exist
     */
    public void addTransientEmptyAcl (String aclId);
}

