/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAce.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;
import org.apache.slide.urm.common.URMInternalServerException;

/**
 * It represents an Access Control Entry (role, action pair).
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMAce extends URMAccessControlerCachedObject{
    
    /** Returns the action
     *
     * @return specified ation
     */
    public URMAction getAction() throws URMInternalServerException;
    
    /** Returns the subject.
     *
     * @return the represented subject
     */
    public URMSubject getSubject();
    
    /** Returns the type of ACE (Grant or Deny)
     *
     * @return the type: GRANT or ...DENY
     */
    public int getType();
    
    /** Returns the true if the ACE is inverted
     *
     * @return boolean, true if the ACE is inverted.
     */
    public boolean getInvert();
}
