/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAcl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import java.util.List;

import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;

/**
 * Represents an Access Control List (one resource with any ACEs).
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 *
 * @see URMAce
*/
public interface URMAcl extends URMAccessControlerCachedObject {
    
    
    /** Returns the internal, unique ID.
     *
     * @return id
     */
    public String getId();
    
    /** Returns the owner.
     *
     * @return the represented subject.
     */
    public URMSubject getOwner();
    
    /** updates the owner.
     *
     * @param newOwner of the subject.
     */
    public void updateOwner(URMSubject newOwner)
    throws URMUpdateException, URMInternalServerException;

    /** Returns the inheritable flag.
     *
     * @return true if the ACL is inheritable.
     */
    public boolean getInheritable();
    
//    /** set the inheritable flag.
//     *
//     * @param true if the ACL should be inheritable, false else.
//    */
//    public void setInheritable(boolean inheritable);
        
    /*  Adds a new ACE to defined position in the ACL or to the end of the ACL if
     *  the position id is > ACL length.
     *
     * @param type of ACE: URMConstants.GRANT or URMConstants.DENY
     * @param subject for which a ACE should be defined
     * @param subjectType, type of the subjec:
     *          URMConstans.USER,
     *          URMConstans.ROLE,
     *          URMConstans.GROUP.
     * @param domain of the subject or null if no domain definition exists
     * @param action definition of the ACE.
     * @param position in the ACE order of the ACL
     *
     * @return ACE id
     *
     * @exception URMUnknownSubjectException if an unknown subject should be used
     * @exception URMUnknownActionException if an unknown action should be used
     *
    public void defineAce(int type, String subject, int subjectType, String domain, String action, int position)
            throws URMUnknownSubjectException, URMUnknownActionException,
                   URMAceCreateException, URMInternalServerException;
*/
    /** Adds a new ACE to defined position in the ACL or to the end of the ACL if
     *  the position id is > ACL length.
     *
     * @param type of ACE: URMConstants.GRANT or URMConstants.DENY
     * @param subject for which a ACE should be defined
     * @param action definition of the ACE.
     * @param position in the ACE order of the ACL
     * @param invert true if the ACE should be inverted
     *
     * @return ACE id
     *
     * @exception URMUnknownSubjectException if an unknown subject should be used
     * @exception URMUnknownActionException if an unknown action should be used
     */
    public void defineAce(int type, URMSubject subject, URMAction action, int position, boolean invert)
            throws URMUnknownSubjectException, URMUnknownActionException,
                   URMAceCreateException, URMInternalServerException;

    /** Returns all the ACEs in the defined order.
     *
     * @return a List of URMAce objects.
     *
     * @see URMAce
     */
    public List getAllAces() throws URMInternalServerException;
    
    /** Returns a ACE contained by the ACL.
     *
     * @param index of the ACE
     * @return the required URMAce object or null if it does not exist.
     *
     * @see URMAce
     */
    public URMAce getAce(int index) throws URMInternalServerException;
    
    /** Removes an ACE element from the ACL.
     *
     * @param index of the ACE
     *
     * @throws URMAclException if any error occurs.
     */
    public void removeAce(int index) throws URMInternalServerException, URMDeleteException;
    
    /** Reorder of the ACEs in the ACL.
     *
     * @param newIds order of ACE ids
     *
     * @throws URMAclException if any error occurs.
     */
    public void updateOrder(int[] newIds)
        throws URMAclException, URMNotImplementedException;
}

