/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAclValidator.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import java.io.*;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.accesscontroler.impl.URMAclValidatorImpl;
import org.apache.slide.urm.common.URMConfigurationException;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorXML;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import java.util.List;

/**
 * An access check can be processed via this class.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public abstract class URMAclValidator {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAclValidator.class.getName());
    
    public static final int URMDeny             = 0;
    public static final int URMPermit           = 1;
    public static final int URMIndeterminate     = 2;
    public static final int URMNotApplicable    = 3;
    
    /** Creates a new instance of the default ACL validator implementation.
     *
     * @return A URMAclValidator object.
     *
     * @throws URMException if an unpredictable internal error occurs.
     */
    public static URMAclValidator newInstance() throws URMConfigurationException, URMException {

        URMConfigurator conf = null;

        try {
            conf = URMConfiguratorXML.newConfigfileConfigurator();
        } catch (ParserConfigurationException e) {
            throw new URMConfigurationException(msLogger, "F", e);
        } catch (SAXException e) {
            throw new URMConfigurationException(msLogger, "F", e);
        } catch (IOException e) {
            throw new URMConfigurationException(msLogger, "F", e);
        }
        
        conf = conf == null ? null : conf.getSubConfigurator("Authenticator/Administrator/AclAdministrator");
        
        return newInstance(conf);
        
    }
    
    /** Creates a new instance of the default ACL validator implementation.
     *
     * @return A URMAclValidator object.
     *
     * @throws URMException if an unpredictable internal error occurs.
     */
    public static URMAclValidator newInstance(URMConfigurator aclAdminConf)
                throws URMConfigurationException, URMException {

        if (aclAdminConf == null)
            throw new URMConfigurationException(MessageLogger.getAndLogMessage(
                                msLogger, "URMCOC0017", "AclAdministrator"));
                                
        return new URMAclValidatorImpl(aclAdminConf);
    }
    
    /** Processes an access check.
     *
     * @param principal the principal of the authenticated user.
     * @param resources List of ACLs in the order they should be validated
     * @param action the required action.
     * @return One of the predefined values URMPermit, URMDeny,
     *              URMIndeterminable, URMNotApplicable.
     *
     * @throws URMAccessCheckException if the access check fails.
     */
    public abstract int accessCheck(URMPrincipal principal, List resources, String action)
                                    throws URMAccessCheckException;
  

}

