/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/URMAction.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler;

import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;

/**
 * This interface represents an action contained by an ACE.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 *
 * @see URMAce
 */
public interface URMAction extends URMAccessControlerCachedObject{
    
    /** Returns the name of the action.
     *
     * @return the name of the action.
     */
    public String getName();

    /** Returns a set of base actions from which the current
     * action is inherited.
     *
     * @return a Set of URMAction objects.
     */
    public Set getBaseActions();
    
    /** Adds a new child action
     *
     * @param name action that should be added
     */
    public void addAction(String name)
        throws URMInsertException , URMInternalServerException, URMForbiddenException;
    
    /** Removes a child action
     *
     * @param name of the action that should be removed
     */
    public void removeAction(String name)
        throws URMDeleteException , URMInternalServerException, URMForbiddenException;
}
