/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/URMAceImpl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
package org.apache.slide.urm.accesscontroler.impl;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.accesscontroler.URMAccessControlerSpi;
import org.apache.slide.urm.accesscontroler.URMAce;
import org.apache.slide.urm.accesscontroler.URMAceCreateException;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;

public class URMAceImpl implements URMAce {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAceImpl.class.getName());

    private int        m_type = 0;
    private URMAction  m_Action = null;
//  private URMSubject m_Subject = null;
    private String     m_Subject = null;
    private int        m_SubjectType = 0;
    private String     m_Domain = null;
    private boolean    m_invert = false;
    private URMAccessControlerSpi mAccessControlerSpi = null;
    private String     m_ActionStr = null;

    public URMAceImpl(int type,
                      String subject,
                      int subjectType,
                      String domain,
                      String action,
                      boolean invert,
                      URMAccessControlerSpi accessControlerSpi)
                      throws URMAceCreateException {

        mAccessControlerSpi = accessControlerSpi;
//      m_Subject = new URMSubjectImpl(subject, subjectType, mAccessControlerSpi);
        m_Subject = subject;
        m_SubjectType = subjectType;
        m_Domain = domain;
        m_invert = invert;
        if (action.equals(URMConstants.URM_ALL_ACTION))
            m_Action = new URMAllActionImpl(mAccessControlerSpi);
        else {
            m_ActionStr = action;
        }
        if (type != org.apache.slide.urm.common.URMConstants.GRANT &&
            type != org.apache.slide.urm.common.URMConstants.DENY)
            throw new URMAceCreateException(MessageLogger.getAndLogMessage(msLogger, "URMCOE000."));
        m_type = type;
    }

    public URMAceImpl(URMAce ace, boolean invert) throws URMAceCreateException{
        URMSubject subj = ace.getSubject();
        if (invert != ace.getInvert()){
            m_invert = invert;
            if (ace.getType() == org.apache.slide.urm.common.URMConstants.GRANT)
                m_type = org.apache.slide.urm.common.URMConstants.DENY;
            else m_type = org.apache.slide.urm.common.URMConstants.GRANT;
        } else {
            m_invert = ace.getInvert();
        }
        m_Subject = subj.getName();
        m_SubjectType = subj.getType();
        m_Domain = subj.getDomain();
        try {
            m_Action = ace.getAction();
        } catch (URMInternalServerException e) {
            throw new URMAceCreateException(msLogger, "E", e);
        }

        if (ace instanceof URMAceImpl) {
            mAccessControlerSpi = ((URMAceImpl) ace).getSpi();
        }
    }

    public URMAceImpl(URMAce ace, URMSubject subj) throws URMAceCreateException{
        m_type = ace.getType();
        m_Subject = subj.getName();
        m_SubjectType = subj.getType();
        m_Domain = subj.getDomain();
        try {
            m_Action = ace.getAction();
        } catch (URMInternalServerException e) {
            throw new URMAceCreateException(msLogger, "E", e);
        }
        m_invert = ace.getInvert();
        if (ace instanceof URMAceImpl) {
            mAccessControlerSpi = ((URMAceImpl) ace).getSpi();
        }
    }

    public URMAccessControlerCachedObject copy(URMAccessControlerSpi spi) throws URMException
    {
        return new URMAceImpl(m_type, new String(m_Subject), m_SubjectType,m_Domain, m_Action.getName(),m_invert,spi);
    }


    public URMAction getAction() throws URMInternalServerException{
        if (m_Action == null) {
            m_Action = mAccessControlerSpi.getAction(m_ActionStr);
        }
        return m_Action;
    }

 
    public URMSubject getSubject() {
        return new URMSubjectImpl(m_Subject, m_SubjectType, m_Domain);
    }

 
    public int getType() {
        return m_type;
    }

        public boolean getInvert()
    {
        return m_invert;
    }

    public URMAccessControlerSpi getSpi() {
        return mAccessControlerSpi;
    }
}

