/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/URMAclImpl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

package org.apache.slide.urm.accesscontroler.impl;

import org.apache.slide.urm.accesscontroler.*;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.impl.URMSubjectImpl;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMParameterException;
import org.apache.slide.urm.common.URMUpdateException;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import java.util.ArrayList;
import java.util.List;

public class URMAclImpl implements URMAcl {

    
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAclImpl.class.getName());
        
    private URMAccessControlerSpi mAccessControlerSpi = null;

    private String m_Id = null;
    private String m_Owner = null;
    private int m_OwnerType = 0;
    private String m_OwnerDomain = null;
    private boolean m_Inheritable = false;
    private boolean m_UpdateOwnerAllowed = false;
    private List m_Aces = null;

    // check whether an ACL must have an owner, otherwise do not allow this call
    public URMAclImpl(URMAccessControlerSpi accessControlerSpi, String id)
        throws URMParameterException {
        mAccessControlerSpi = accessControlerSpi;
        m_Id = new String (id);
        
    }

    public URMAclImpl(URMAccessControlerSpi accessControlerSpi,
                      String id,
                      String owner,
                      int ownerType,
                      String domain,
                      boolean inheritable,
                      List aces)
            throws URMParameterException {
                        
            
        if (owner == null)
            throw new URMParameterException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0026", "owner"));
             
        mAccessControlerSpi = accessControlerSpi;
        m_Id = new String (id);
        m_Owner = new String (owner);
        m_OwnerType = ownerType;
        if (domain == null) m_OwnerDomain = null;
        else m_OwnerDomain = new String (domain);
        m_Inheritable = inheritable;
        m_Aces = new ArrayList(aces);
    }
    
    public URMAccessControlerCachedObject copy(URMAccessControlerSpi spi) throws URMException
    {
        try {
            return new URMAclImpl(spi, m_Id, m_Owner, m_OwnerType, m_OwnerDomain, m_Inheritable, m_Aces);
        } catch (URMParameterException e)
        {
            throw new URMException(msLogger, "E", e);
        }
    }

    public String getId() {
        return m_Id;
    }

    public URMSubject getOwner() {
        return new URMSubjectImpl(m_Owner, m_OwnerType, m_OwnerDomain);
    }

    public boolean getInheritable() {
        return m_Inheritable;
    }

//  public void setInheritable(boolean inheritable) {
//       m_Inheritable = inheritable;
        //mAccessControlerSpi.setInheritable(inheritable);
//  }

    public List getAllAces() throws URMInternalServerException {
        if (m_Aces == null) {
            m_Aces = mAccessControlerSpi.getAllAces(m_Id);
        }
        return m_Aces;
    }

    public URMAce getAce(int index) throws URMInternalServerException{
        if (m_Aces == null) {
            m_Aces = mAccessControlerSpi.getAllAces(m_Id);
        }
        return (URMAce) m_Aces.get(index);
    }

    public void updateOrder(int[] newIds)
        throws URMAclException, URMNotImplementedException {
        try {
            mAccessControlerSpi.updateOrder(m_Id, newIds);
            m_Aces = mAccessControlerSpi.getAllAces(m_Id);
        } catch (Exception e) {
             throw new URMAclException(msLogger, "E", e);
        }
    }

    public void updateOwner(URMSubject newOwner) throws URMUpdateException, URMInternalServerException {
        mAccessControlerSpi.updateOwner(m_Id,
                                        newOwner.getName(),
                                        newOwner.getType(),
                                        newOwner.getDomain());
    }

    public void defineAce_old(int type, String subject, int subjectType, String domain, String action, int position, boolean invert)
            throws URMUnknownSubjectException, URMUnknownActionException,
                   URMAceCreateException, URMInternalServerException {
        
        m_Aces = mAccessControlerSpi.defineAce(m_Id, m_Owner, m_OwnerType, m_OwnerDomain,m_Inheritable, type, subject, subjectType,
                                      domain, action, position, invert, m_Aces);
//        m_Aces = mAccessControlerSpi.getAllAces(m_Id);
    }

    public void defineAce(int type, URMSubject subject, URMAction action, int position, boolean invert)
            throws URMUnknownSubjectException, URMUnknownActionException,
                   URMAceCreateException, URMInternalServerException {
        String domain = null;
        
        if (subject instanceof URMUser)
            domain = ((URMUser)subject).getDomain();
        if (subject instanceof URMGroup)
            domain = ((URMGroup)subject).getDomain();
                    
//        defineAce(type, subject.getName(), subject.getType(), domain,
//                      action.getName(), position, invert);
        m_Aces = mAccessControlerSpi.defineAce(m_Id, m_Owner, m_OwnerType,
                               m_OwnerDomain,m_Inheritable, type,
                               subject.getName(), subject.getType(),
                               domain, action.getName(), position, invert, m_Aces);
    }

    public void removeAce(int index) throws URMInternalServerException, URMDeleteException {
        if (index >= 0) {
            m_Aces = mAccessControlerSpi.removeAce(m_Id, m_Owner, m_OwnerType, m_OwnerDomain,m_Inheritable, index, m_Aces);
//          m_Aces = mAccessControlerSpi.getAllAces(m_Id);
        }
    }

}
