/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/URMActionImpl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

package org.apache.slide.urm.accesscontroler.impl;

import java.util.HashSet;
import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.accesscontroler.URMAccessControlerSpi;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.URMException;
import java.util.Iterator;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;

public class URMActionImpl implements URMAction {
    
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAclImpl.class.getName());
        
    protected URMAccessControlerSpi m_AccessControlerSpi = null;

    protected String m_Action = null;
    protected Set m_baseActions = null;
    
    public URMActionImpl(URMAccessControlerSpi accessControlerSpi,
                         String action, Set baseActions) {
        m_AccessControlerSpi = accessControlerSpi;
        m_Action = action;
        m_baseActions = (baseActions == null ? new HashSet() : baseActions);
    }
    
    public URMAccessControlerCachedObject copy(URMAccessControlerSpi spi) throws URMException
    {
        Set baseActions = new HashSet();
        Iterator iter = m_baseActions.iterator();
        while (iter.hasNext()) {
            baseActions.add(new String ((String) iter.next()));
        }
        return new URMActionImpl(spi, new String (m_Action), baseActions);
    }

    public String getName() {
        return m_Action;
    }

    public Set getBaseActions() {
        /*        try {
            m_AccessControlerSpi.loadActionSetIntoCache(m_baseActions);
        } catch (Exception e){}
         */
        return m_baseActions;
    }

    public void addAction(String name)
        throws URMInsertException , URMInternalServerException, URMForbiddenException {
        m_AccessControlerSpi.addBaseAction(m_Action, name);
        m_baseActions.add(name);
    }

    public void removeAction(String name)
                throws URMDeleteException , URMInternalServerException, URMForbiddenException {
        m_AccessControlerSpi.removeBaseAction(m_Action, name);
        m_baseActions.remove(name);
    }
    
    public boolean equals (Object obj) {
        if (obj instanceof URMAction) {
            if ((((URMAction) obj).getName()).equals(m_Action)) return true;
        }
        return false;
    }
}
