/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/URMAllActionImpl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

package org.apache.slide.urm.accesscontroler.impl;

import java.util.HashSet;
import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.accesscontroler.URMAccessControlerSpi;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.URMException;
import org.apache.slide.urm.utils.accesscontrolercache.URMAccessControlerCachedObject;

public class URMAllActionImpl extends URMActionImpl {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAllActionImpl.class.getName());

    public URMAllActionImpl(URMAccessControlerSpi accessControlerSpi) {
        super(accessControlerSpi, URMConstants.URM_ALL_ACTION, null);
    }

    public Set getBaseActions() {
        try {
            return m_AccessControlerSpi.getAllActionsAsString();
        } catch (Exception e) {
            return new HashSet();
        }
    }
    
    public URMAccessControlerCachedObject copy(URMAccessControlerSpi spi) throws URMException
    {
        return new URMAllActionImpl(spi);
    }

    public void addAction(String name)
        throws URMInsertException , URMInternalServerException, URMForbiddenException {
        throw new URMForbiddenException (MessageLogger.getAndLogMessage(msLogger, "URMTRC0008"));
    }

    public void removeAction(String name)
        throws URMDeleteException , URMInternalServerException, URMForbiddenException {
        throw new URMForbiddenException (MessageLogger.getAndLogMessage(msLogger, "URMTRC0008"));
    }

}
