/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/URMPermissionResultImpl.java,v 1.4 2005/03/02 10:53:32 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

package org.apache.slide.urm.accesscontroler.impl;
import org.apache.slide.urm.accesscontroler.URMPermissionResult;
import org.apache.slide.urm.accesscontroler.URMAce;



public class URMPermissionResultImpl implements URMPermissionResult
{
    private int _permission = 0;
    private URMAce _ace = null;
    private String _resourceID = null;
    
    public URMPermissionResultImpl(int permission, URMAce ace, String resourceID) {
        _permission = permission;
        _ace = ace;
        _resourceID = resourceID;
    }
    
    public URMPermissionResultImpl(URMAce ace, String resourceID) {
        _ace = ace;
        _resourceID = resourceID;
    }
        
    
    public URMAce getAce()
    {
        return _ace;
    }
    
    public String getResource()
    {
        return _resourceID;
    }
    
    public int getPermission()
    {
        return _permission;
    }
    
    public void setPermission(int permission)
    {
        _permission = permission;
    }
    
}

