/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/dummy/URMAccessControlerSpiDummy.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.accesscontroler.impl.dummy;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.slide.urm.authenticator.URMDBTransactionException;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import org.apache.slide.urm.accesscontroler.URMAccessCheckException;
import org.apache.slide.urm.accesscontroler.URMAccessControlerSpi;
import org.apache.slide.urm.accesscontroler.URMAce;
import org.apache.slide.urm.accesscontroler.URMAceCreateException;
import org.apache.slide.urm.accesscontroler.URMAcl;
import org.apache.slide.urm.accesscontroler.URMAclException;
import org.apache.slide.urm.accesscontroler.URMAclValidator;
import org.apache.slide.urm.accesscontroler.URMAction;
import org.apache.slide.urm.accesscontroler.URMActionIdNotUniqueException;
import org.apache.slide.urm.accesscontroler.URMActionInUseException;
import org.apache.slide.urm.accesscontroler.URMUnknownActionException;
import org.apache.slide.urm.accesscontroler.URMUnknownSubjectException;
import org.apache.slide.urm.accesscontroler.impl.URMAceImpl;
import org.apache.slide.urm.accesscontroler.impl.URMActionImpl;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConnectionException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMConfiguratorUtil;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;



/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class URMAccessControlerSpiDummy implements URMAccessControlerSpi {
    
    
    public void loadActionSetIntoCache(Set actions) throws URMInternalServerException
    {
        // TODO
    }
    
    private String  m_ActionName;
    private String  m_AclOwner;
    private int     m_AclOwnerType;
    private String  m_AclOwnerDomain;
    private String  m_AclId;
    private boolean m_Inheritable = false;
    private URMAcl  m_URMAcl;
    private int     m_Id;
    private URMAce  m_URMAce;
    private List    m_AllAces = null;

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAccessControlerSpiDummy.class.getName());
    
    private String mDatabaseUri = null;
    private String mCollectionName = null;
    private TConnection mConnection = null;
    private TXMLObjectAccessor mObjectAccessor = null;
    private Object mOwner = null;
    private URMConfigurator mConfigurator = null;
    
    private boolean mIsAlreadyClosed = false;
    
    private TConnection getConnection(String domain, String userId, String password)
            throws URMConnectionException {
        TConnection conn = null;
        try {
            TConnectionFactory cf = TConnectionFactory.getInstance();
            if (domain == null)
                conn = cf.newConnection(mDatabaseUri, userId, password);
            else
                conn = cf.newConnection(mDatabaseUri, domain, userId, password);
        } catch (TServerNotAvailableException  ex) {
            TException de = ex.getDeepestTException();
            if (de == null)
                de = ex;
            throw new URMConnectionException(MessageLogger.getAndLogMessage(msLogger, "F", de));
        }
        return conn;
    }


    /** Constructor of the Tamino role administrator. The passed configurator
     * must specify the "databaseUri" attribute. If the "collectionName" is not
     * specified than the default one URMConstants#DEFAULT_TAMINO_COLLECTION is used.
     *
     * @param roleAdminConf role administrator configuration.
     */
    public URMAccessControlerSpiDummy(URMConfigurator roleAdminConf, Object owner) throws URMConnectionException {
        mConfigurator = roleAdminConf;
        mOwner = owner;
        
        URMConfigurator attrbConfig = roleAdminConf.getSubConfigurator("/Authenticator/Administrator");
        Iterator attrs = URMConfiguratorUtil.getAttributeList(attrbConfig, msLogger);
        while (attrs != null && attrs.hasNext()) {
            URMConfigurator attrconf = ((URMConfigurator)attrs.next());
            Properties attr = attrconf.getProperties();
            if (attr == null)
                continue;
            String attrname = (String)attr.get("name");
            if (attrname == null)
                continue;
            if (attrname.equals("databaseUri"))
                mDatabaseUri = (String)attr.get("value");
            else if (attrname.equals("collectionName")) {
                mCollectionName = (String)attr.get("value");
            }
        }
        mConnection = getConnection(null, null, null);
        try {
            mConnection.useAutoCommitMode();
        } catch (TTransactionModeChangeException e) {
            throw new URMConnectionException(msLogger, "F", e);
        }
        mObjectAccessor = mConnection.newXMLObjectAccessor(
                            TAccessLocation.newInstance(mCollectionName),
                            TDOMObjectModel.getInstance() );
    }

    public URMAccessControlerSpi duplicateObject(Object owner) throws URMConnectionException {
        return new URMAccessControlerSpiDummy(mConfigurator, owner);
    }

    /******************* URMAclAdmin methods *************** start ************/
    /* (non-Javadoc)
     */
    public URMAcl getAcl(String id) {
        if (m_URMAcl != null)
            return m_URMAcl;
        else {
            String strAcl = createAcl(id, "dk", org.apache.slide.urm.common.URMConstants.USER, null, false);
            return m_URMAcl;
        }
    }

    /* (non-Javadoc)
     */
    public String createAcl(String id, String owner, int ownerType,
                            String ownerDomain, boolean inheritable) {
        m_AclId = id;
        m_AclOwner = owner;
        m_AclOwnerType = ownerType;
        m_Inheritable = inheritable;
        return id;
    }

    /*
     *  (non-Javadoc)
     */
    public List getAclPath(List aces)
            throws URMInternalServerException {
        return null;
    }
 
    /* (non-Javadoc)
     */
    public void deleteAcl(String acl) {
        m_AclId = null;
        m_AclOwner = null;
    }
    
    /* (non-Javadoc)
     */
    public URMAction createAction(String name) throws URMActionIdNotUniqueException {
        m_ActionName = name;
        return new URMActionImpl(this, name, null);
    }

    /* (non-Javadoc)
     */
    public void deleteAction(String name) throws URMActionInUseException {
        // Nix
    }

    /* (non-Javadoc)
     */
    public URMAction getAction(String name)
        throws URMInternalServerException {
        return new URMActionImpl(this, name, null);
    }
    
    /* (non-Javadoc)
     */
    public Set getAllActions()
        throws URMInternalServerException {
        return null;
    }

    /* (non-Javadoc)
    */
    public Set getAllActionsAsString() throws URMInternalServerException {
        // TODO Auto-generated method stub
        return null;
    }

    /*
    public Set getUserWithPermissionReport(String action, List resource) throws URMInternalServerException
    {
        return new HashSet();
    }
    
    public Set getUserPermissionReport(String user, String domain, List resource) throws URMInternalServerException
    {
        return new HashSet();
    }
    
    public boolean hasPermissionReport(String user, String domain, List resource, String action) throws URMInternalServerException
    {
        return false;
    }
     */
    /******************* URMAclAdmin methods ******************* end **********/

    /******************* URMAcl methods ******************** start ************/

    /* (non-Javadoc)
     */
    public void setAclInheritable(String aclId, boolean inheritable) {
        // Nix
    }
    
    /* (non-Javadoc)
     */
    public List getAllAces(String aclId) throws URMInternalServerException {
        if (m_AllAces == null) {
            if (m_URMAce == null)
                try {
                    m_URMAce = new URMAceImpl(org.apache.slide.urm.common.URMConstants.GRANT,
                                           "dk",
                                           1,
                                           null,
                                           "delete",
                                              false,
                                           this);
                } catch (URMAceCreateException e) {
                    throw new URMInternalServerException(msLogger, "F", e);
                }
            m_AllAces.add(m_URMAce);
        }
        return m_AllAces;
    }
    
    /* (non-Javadoc)
    */
    public void updateOrder(String aclId, /*int[] oldIds,*/ int[] newIds)
        throws URMAclException {
        // Schoen waer's
    }

    /* (non-Javadoc)
    */
    public void updateOwner(String aclId, String owner, int ownerType, String domain) {
        m_AclOwner = owner;
        m_AclOwnerType = ownerType;
        m_AclOwnerDomain = domain;
    }
    
    /* (non-Javadoc)
    */
    public List defineAce(String aclId,
                          String resOwner,
                          int resOwnerType,
                          String resDomain,
                          boolean resInherit,
                          int type,
                          String subject,
                          int subjectType,
                          String domain,
                          String action,
                          int position,
                          boolean invert,
                          List list)
                        throws URMUnknownSubjectException,
                               URMUnknownActionException,
                               URMAceCreateException {
        m_URMAce = new URMAceImpl(type, subject, subjectType,
                                  domain, action ,false,this);
        return null;
    }

    /* (non-Javadoc)
     */
    public void removeAce(String aclId, int id) throws URMDeleteException, URMInternalServerException {
        // Nix
    }
    
    public List removeAce (String aclId,
                            String resOwner,
                            int resOwnerType,
                            String resDomain,
                            boolean resInherit,
                            int id,
                            List list) throws URMDeleteException, URMInternalServerException {
        return null;
    }
    
    /******************* URMAcl methods ************************ end **********/


    /******************* URMAclValidator methods *********** start ************/
    /* (non-Javadoc)
     */
    public int accessCheck(
        URMPrincipal principal,
        List resourceList,
        int action)
        throws URMAccessCheckException {

        return 1;  // why not true/false ???
    }

    /******************* URMAclValidator methods *************** end **********/


    /******************* URMAclIterator methods ************ start ************/
    /* (non-Javadoc)
     */
    public URMAcl getNext() {
        return null;
    }

    /* (non-Javadoc)
    */
    public boolean hasNext() {
        return false;
    }
    
    /******************* URMAclIterator methods **************** end **********/
    
    
    /******************* URMAction methods ***************** start ************/

    /* (non-Javadoc)
    */
    public void removeAction(String name) {
        // Nee
    }

    /*
     *
     */
    public void addBaseAction(String name, String baseAction) {
        //
    }
        
    /*
     *
     */
    public void removeBaseAction(String name, String baseAction){
        // nix
    }
        
    /******************* URMAction methods ********************* end **********/


    /******************* URMSemantic methods *************** start ************/
    
    /* (non-Javadoc)
     */
    public int checkPermission(
        URMPrincipal principal,
        URMAclValidator aclIterator,
        String action)
        throws URMAccessCheckException {
            return 0;
    }

    /******************* URMSemantic methods ******************* end **********/

    public List getAclsWithSpecificAction(List inPath,
                                             List inActions)
        throws URMInternalServerException {
        return null;
    }


    /* (non-Javadoc)
     */
    public void beginTransaction() throws URMDBTransactionException, URMInternalServerException {
    }


    /* (non-Javadoc)
     */
    public void endTransaction(boolean manner) throws URMDBTransactionException, URMInternalServerException {
    }

        /**
     * Signals the cache that an ACL does not exist
     */
    public void addTransientEmptyAcl (String aclId){
    }
}
