/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/accesscontroler/impl/semantic/firstmatch/URMFirstMatchSemanticFactory.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

package org.apache.slide.urm.accesscontroler.impl.semantic.firstmatch;

import org.apache.slide.urm.accesscontroler.URMSemanticFactory;
import org.apache.slide.urm.accesscontroler.URMSemantic;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.URMException;

public class URMFirstMatchSemanticFactory extends URMSemanticFactory {
    
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMFirstMatchSemanticFactory.class.getName());
        
    URMConfigurator mSemanticConf = null;
    String mPredefinedActionSemantic = null;
    
    public URMFirstMatchSemanticFactory(URMConfigurator semanticConf) {
        mSemanticConf = semanticConf;
        mPredefinedActionSemantic = mSemanticConf.getProperties().getProperty("PredefinedActionSemantic");
    }

    public URMSemantic newSemantic() throws URMException {
        /*/URMConfigurator conf = null;

        try {
            conf = URMConfiguratorXML.newConfigfileConfigurator();
        } catch (ParserConfigurationException e) {
            throw new URMException(msLogger, "E", e);
        } catch (SAXException e) {
            throw new URMException(msLogger, "E", e);
        } catch (IOException e) {
            throw new URMException(msLogger, "E", e);
        } catch (URMException e) {
            throw new URMException(msLogger, "E", e);
        }
        
        URMConfigurator authenconf = conf.getSubConfigurator("Authenticator");
        URMConfigurator adminconf = authenconf.getSubConfigurator("Administrator");
        URMConfigurator semanticconf = adminconf.getSubConfigurator("AclSemantic");
        String preSemantic= semanticconf.getProperties().getProperty("PredefinedActionSemantic");*/
        return new URMFirstMatchSemantic(mPredefinedActionSemantic);
    }

}

