/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/URMAdministrator.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleAdministrator;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleManagerSpi;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMMetadataPropsSpi;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManager;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManagerSpi;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInternalServerException;

/**
 * Provides a user, group and role manager interface. All the user database
 * and role administrator methods are called via this interface.
 * This architecture makes possible to replace the whole underlying
 * implementation through implementing the URMAuthenticator and
 * URMAdministrator interfaces and extending the
 * URMAuthenticatorFactory class.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

public interface URMAdministrator extends URMRoleAdministrator, URMUserDBManager {

  /**
   * Returns the RoleManageSpi
   *
   * @return URMRoleManagerSpi
   */
    public URMRoleManagerSpi getRoleManager();

    /**
     * Returns the MetaDataPropsSpi
     *
     * @return URMMetaDatapropsSpi
     */
    public URMMetadataPropsSpi getMetaDataprop();

    /**
     * Returns the UserDBManagerSpi
     *
     * @return URMUserDBManagerSpi
     */
    public URMUserDBManagerSpi getUserDBManager();

    /** Returns the current Principal Owner Handle
     *
     */
    public Object getOwner();
     
    /**
     * Returns the URMUser object of a user
     *
     * @param user name of the user whose properties are searched.
     *
     * @param domain the domain against the operation is executed if a domain is defined,
     * null else
     *
     * @return URMUser representation of an user
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs.
     */
    public URMUser getUser(String user, String domain)
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
            
    /**
     * Returns the URMGroup object of a group
     *
     * @param group name of the group whose properties are searched.
     *
     * @param domain the domain against the operation is executed if a domain is defined,
     * null else
     *
     * @return URMGroup representation of a group
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs.
     */
    public URMGroup getGroup(String group, String domain)
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
     
    /**
     * Returns the a URMSubject of type URMConstans.ALL.
     * Each user, group, role is represented by this subject.
     *
     * @return URMSubject representation of URMConstans.ALL
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs.
     */
    public URMSubject getALLSubject()
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;


    public void synchronizeUsersGroupsRoles()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException, URMDeleteException;
                
    /**
     * Close the connection to the meta store.
     *
     * @throws URMCloseConnectionException if any error occures during tho close operation.
     */
    //public void close() throws URMCloseConnectionException;


}

