/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/URMAuthenticatorException.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator;

import org.apache.slide.urm.URMException;

import org.apache.log4j.Logger;

/**
 * Exception class to throw it when the authentication fails.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMAuthenticatorException extends URMException {
    /* Creates new instance and passes the message through to the URMException.
     */
    public URMAuthenticatorException(String msg) {
        super(msg);
    }
    
    /* Creates a new instance containing the passed exception.
     */
    public URMAuthenticatorException(Throwable e) {
        super(e);
    }

    /* Creates a new instance containing the passed exception and also creates
     * a log entry containing the the message from the passed Throwable.
     */
    public URMAuthenticatorException(Logger logger, String level, Throwable e) {
        super(logger, level, e);
    }
}
