/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/URMSubject.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator;

/**
 * URMSubject represents the subjcts in ACE definitions. Subjects that
 * should be used in ACE definitions or as resource owner have to
 * implement this interface.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMSubject {
    
    /**
     * Returns the name of the subject.
     *
     * @return Name of the subject.
     */
    public String getName();
    
    /**
     * Returns the type of the subject. The following typs exist:
     *          URMConstans.USER,
     *          URMConstans.ROLE,
     *          URMConstans.GROUP,
     *          URMConstans.ALL.
     *
     * @return subject type.
     */
    public int getType();

    /** Returns the users domain or null if no domain is defined
     *
     * @return domain
     */
    public String getDomain();
    

}
