/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/impl/URMGuestAdministratorImpl.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.authenticator.impl;

import java.util.Properties;
import java.util.Set;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleManagerSpi;
import org.apache.slide.urm.authenticator.rolemanager.impl.URMRoleGuestImpl;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMMetadataPropsSpi;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManagerSpi;
import org.apache.slide.urm.common.URMCloseConnectionException;
import org.apache.slide.urm.common.URMConfigurationException;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConnectionException;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.utils.URMClassInstantiator;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import org.apache.slide.urm.authenticator.URMSubject;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMGuestAdministratorImpl implements URMAdministrator {
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMGuestAdministratorImpl.class.getName());

    protected URMRoleManagerSpi mRoleManagerSpi = null;
    protected Object mOwner = null;

    protected URMUserDBManagerSpi mUserDBManagerSpi = null;
    protected URMMetadataPropsSpi mMetadataPropsSpi = null;

    public URMMetadataPropsSpi getMetaDataprop() {
        return mMetadataPropsSpi;
    }
    public URMUserDBManagerSpi getUserDBManager(){
        return mUserDBManagerSpi;
    }

    public URMRoleManagerSpi getRoleManager() {
        return mRoleManagerSpi;
    }
    
    public URMGuestAdministratorImpl(URMConfigurator adminConf, Object owner)
            throws URMConfigurationException {
        
        // Create the RoleManagerSpi
        
        URMConfigurator conf = (URMConfigurator)adminConf.getSubConfigurators().get("RoleManager");
        Properties props = conf.getProperties();
        String class_name = props != null ? (String)props.get(
                                        URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME) : null;
        if (class_name == null)
            throw new URMConfigurationException(
                MessageLogger.getAndLogMessage(msLogger, "URMCOC0002",
                    URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME, "Administrator/RoleManager"));

        Object radmin_params[] = { conf, owner };
        try {
            mRoleManagerSpi = (URMRoleManagerSpi)URMClassInstantiator.newInstance(class_name, radmin_params);
        } catch (URMException e) {
            throw new URMConfigurationException(MessageLogger.getAndLogMessage(msLogger, "F", e));
        }

    }

    public URMGuestAdministratorImpl(URMAdministrator inAdmin) {
        mRoleManagerSpi = inAdmin.getRoleManager();
    }

    public URMGuestAdministratorImpl(URMAdministrator inAdmin, Object owner) throws URMConnectionException {
        mRoleManagerSpi = inAdmin.getRoleManager().duplicateObject(owner);
    }
    
    /******************* Role Manager *****************************/

    public boolean isRole(String role)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        if (!mRoleManagerSpi.isRole(role)) {
            if (role != null && (role.equals(URMConstants.URM_ROOT_ROLE)
                                || role.equals(URMConstants.URM_ADMIN_ROLE)
                                || role.equals(URMConstants.URM_GUEST_ROLE)))
                return true;
            else
                return false;
        }
        else
            return true;
    }

    public URMRole createRole(String role)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteRole(String role)
            throws URMNotImplementedException, URMInternalServerException,
                   URMForbiddenException, URMDeleteException {
       throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public URMRole getRole(String role)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        if (mRoleManagerSpi.isRole(role))
            return new URMRoleGuestImpl(role, mRoleManagerSpi);
        else
            return null;
    }

    public Set getAllRoles()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleGuestImpl.getURMRoleObjectSetFromSubjectSet(
                        mRoleManagerSpi.getAllRoles(), mRoleManagerSpi);
    }
    /******************* Role Manager end *************************/

    /******************* UserDB Manager ***************************/
    

    public URMUser getUser(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public URMGroup getGroup(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }
    
    /**
     * Returns the a URMSubject of type URMConstans.ALL.
     * Each user, group, role is represented by this subject.
     *
     * @return URMSubject representation of URMConstans.ALL
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs.
     */
    public URMSubject getALLSubject()
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return new URMSubjectImpl("ALL", URMConstants.ALL, null);
    }

    public boolean isUser(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public boolean isGroup(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public Set getAllGroups(String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public Set getAllUsers(String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void createUser(String user, char[] password, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    /* (non-Javadoc)
     * @see com.softwareag.urm.authenticator.userdb.URMUserDBManager#createGroup(java.lang.String, java.lang.String)
     */
    public void createGroup(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteUser(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteGroup(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    /******************* UserDB Manager end ***********************/
 
    public void synchronizeUsersGroupsRoles() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException, URMDeleteException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void close() throws URMCloseConnectionException {
        mRoleManagerSpi.close();
    }

    public Object getOwner() {
        return mOwner;
    }
}

