/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/impl/URMSubjectImpl.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator.impl;

import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMSubject;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMSubjectImpl implements URMSubject {

    private String                m_Name   = null;
    private int                   m_Type   = 0;
    private String                m_Domain = null;
    private int                   m_HashCode;
    private String                m_ToString;
//  private URMAccessControlerSpi m_AccessControlerSpi = null;
    
    public URMSubjectImpl(String inName,
                          int type,
                          String inDomain
                          /* URMAccessControlerSpi accessControlerSpi */ ) {
//      m_AccessControlerSpi = accessControlerSpi;    	
    	if ((inDomain != null) && !URMAuthenticator.isCaseSensitive() && (type != org.apache.slide.urm.common.URMConstants.ROLE) ) m_Domain = inDomain.toUpperCase();
    	else m_Domain = inDomain;
    	// check if case sensitive
    	if ((inName != null) && !URMAuthenticator.isCaseSensitive()  && (type != org.apache.slide.urm.common.URMConstants.ROLE)) m_Name = inName.toUpperCase();
    	else m_Name = inName;
   
        m_Type   = type;
        m_ToString = String.valueOf(type) + "@" + m_Domain + "/" + m_Name;
        m_HashCode = m_ToString.hashCode();
    }

    public String getName() {
        return m_Name;
    }

    public int getType() {
        return m_Type;
    }
    
    /*
     *
     */
    public String getDomain() {
        return m_Domain;
    }

    
    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        // class check
        if (!(obj instanceof URMSubject))
            return false;

        URMSubject insubj = (URMSubject)obj;
        // name
        String tmp = insubj.getName();
        if (m_Name == null) {
            if (tmp != null)
                return false;
        }
        else {
            if (tmp == null)
                return false;
            else if (!m_Name.equals(tmp))
                return false;
        }
        // domain
        tmp = insubj.getDomain();
        if (m_Domain == null) {
            if (tmp != null)
                return false;
        }
        else {
            if (tmp == null)
                return false;
            else if (!m_Domain.equals(tmp))
                return false;
        }
        // type
        return (m_Type == insubj.getType());
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return m_HashCode;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return m_ToString;
    }

}
