/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/impl/URMUserAdministratorImpl.java,v 1.5 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.5 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.authenticator.impl;

import java.util.Properties;
import java.util.Set;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMAdministrator;
import org.apache.slide.urm.authenticator.userdb.URMGroup;
import org.apache.slide.urm.authenticator.userdb.URMMetadataPropsSpi;
import org.apache.slide.urm.authenticator.userdb.URMUser;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManagerSpi;
import org.apache.slide.urm.authenticator.userdb.impl.URMGroupImpl;
import org.apache.slide.urm.authenticator.userdb.impl.URMUserImpl;
import org.apache.slide.urm.common.URMCloseConnectionException;
import org.apache.slide.urm.common.URMConfigurationException;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMConnectionException;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.utils.URMClassInstantiator;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import org.apache.slide.urm.authenticator.rolemanager.impl.URMRoleImpl;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMUserAdministratorImpl extends URMGuestAdministratorImpl {
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMUserAdministratorImpl.class.getName());
        
    public URMUserAdministratorImpl(URMConfigurator adminConf, Object userDb,
                                String username, char[] password, String domain, Object owner)
            throws URMConfigurationException {
        super (adminConf, owner);
                
        // Create the UserDBManagerSpi (SSX)

        URMConfigurator conf = (URMConfigurator)adminConf.getSubConfigurators().get("UserDatabase");
        Properties props = conf.getProperties();
        String class_name = props != null ? (String)props.get(
                                    URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME) : null;
        if (class_name == null)
            throw new URMConfigurationException(
                MessageLogger.getAndLogMessage(msLogger, "URMCOC0002",
                    URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME, "Administrator/UserDatabase"));

        try {
            Object uadmin_params[] = { conf, userDb, username, password, domain };
            mUserDBManagerSpi = (URMUserDBManagerSpi)URMClassInstantiator.newInstance(class_name, uadmin_params);
            conf = conf.getSubConfigurator("MetadataProperties");
            if (conf != null) {
                props = conf.getProperties();
                class_name = props != null ? (String)props.get(
                                            URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME) : null;
                if (class_name == null)
                    throw new URMConfigurationException(
                        MessageLogger.getAndLogMessage(msLogger, "URMCOC0002",
                            URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME, "Administrator/UserDatabase/MetadataProperties"));
                Object mprops_params[] = { conf, owner };
                mMetadataPropsSpi = (URMMetadataPropsSpi)URMClassInstantiator.newInstance(class_name, mprops_params);
            }
            else
                MessageLogger.logMessage(msLogger, "URMCOW0028");
        } catch (URMException e) {
            throw new URMConfigurationException(MessageLogger.getAndLogMessage(msLogger, "F", e));
        }
    }
    
    public URMUserAdministratorImpl(URMAdministrator inAdmin, Object owner) throws URMConnectionException {
        super(inAdmin, owner);
        mUserDBManagerSpi = inAdmin.getUserDBManager();
        URMMetadataPropsSpi mp_spi = inAdmin.getMetaDataprop();
        if (mp_spi != null)
            mMetadataPropsSpi = mp_spi.duplicateObject(owner);
    }
    
    public URMUserAdministratorImpl(URMAdministrator inAdmin) {
        super(inAdmin);
        mUserDBManagerSpi = inAdmin.getUserDBManager();
        mMetadataPropsSpi = inAdmin.getMetaDataprop();
    }
    
    public URMUserAdministratorImpl(URMConfigurator adminConf, URMUserDBManagerSpi userDbSpi, Object owner) throws URMConfigurationException { 
        super (adminConf, owner);
        mUserDBManagerSpi = userDbSpi;
        try {
        	URMConfigurator root_conf = adminConf.getRootConfigurator();
        	URMConfigurator conf = root_conf.getSubConfigurator("Authenticator/Administrator/UserDatabase/MetadataProperties");
            if (conf != null) {
                Properties props = conf.getProperties();
                String class_name  = props != null ? (String)props.get(
                                            URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME) : null;
                if (class_name == null)                	
                    throw new URMConfigurationException(
                        MessageLogger.getAndLogMessage(msLogger, "URMCOC0002",
                            URMConstants.FACTORY_CLASS_ATTRIBUTE_NAME, "Administrator/UserDatabase/MetadataProperties"));
                Object mprops_params[] = { conf, owner };
                mMetadataPropsSpi = (URMMetadataPropsSpi)URMClassInstantiator.newInstance(class_name, mprops_params);
            }
            else {
                MessageLogger.logMessage(msLogger, "URMCOW0028");
        	}
        } catch (URMException e) {
            throw new URMConfigurationException(MessageLogger.getAndLogMessage(msLogger, "F", e));
        }   
    }
    
    /******************* UserDB Manager ***************************/

    public Set getAllGroups(String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMGroupImpl.getURMGroupObjectSetFromStringSet(
                        mUserDBManagerSpi.getAllGroups(domain), domain,
                        mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);
    }

    public Set getAllUsers(String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMUserImpl.getURMUserObjectSetFromStringSet(
                        mUserDBManagerSpi.getAllUsers(domain), domain,
                        mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);
    }

    public boolean isUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return mUserDBManagerSpi.isUser(user, domain);
    }

    public boolean isGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return mUserDBManagerSpi.isGroup(group, domain);
    }

    public URMUser getUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
    	if (mUserDBManagerSpi.isUser(user, domain))        	
            return new URMUserImpl(user, domain, mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);
        else
            return null;
    }

    public URMGroup getGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        if (mUserDBManagerSpi.isGroup(group, domain))
            return new URMGroupImpl(group, domain, mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);
        else
            return null;
    }

    public void createUser(String user, char[] password, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void createGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException{
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    /******************* UserDB Manager end ***********************/

    public void close() throws URMCloseConnectionException {
        super.close();
        if (mUserDBManagerSpi != null) mUserDBManagerSpi.close();
        if (mMetadataPropsSpi!= null)  mMetadataPropsSpi.close();
    }

    public URMRole getRole(String role)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        if (mRoleManagerSpi.isRole(role))
            return new URMRoleImpl(role, mRoleManagerSpi, mUserDBManagerSpi, mMetadataPropsSpi);
        else
            return null;
    }

    public Set getAllRoles()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleImpl.getURMRoleObjectSetFromSubjectSet(
                        mRoleManagerSpi.getAllRoles(), mRoleManagerSpi);
    }
}
