/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/impl/jndi/URMAuthenticatorJNDI.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.authenticator.impl.jndi;

import java.util.Map;

import org.apache.slide.urm.accesscontroler.impl.URMAclAdministratorImpl;
import org.apache.slide.urm.authenticator.URMAuthenticationFailsException;
import org.apache.slide.urm.authenticator.URMAuthenticator;
import org.apache.slide.urm.authenticator.URMAuthenticatorException;
import org.apache.slide.urm.authenticator.impl.URMAdministratorImpl;
import org.apache.slide.urm.authenticator.userdb.impl.jndi.URMUserDBManagerSpiJNDI;
import org.apache.slide.urm.common.URMCloseConnectionException;
import org.apache.slide.urm.common.URMConfigurationException;
import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.common.URMPrincipal;
import org.apache.slide.urm.common.impl.URMPrincipalImpl;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;

/**
 * @author zsa
 */
public class URMAuthenticatorJNDI extends URMAuthenticator {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMAuthenticatorJNDI.class.getName());
        
    private static final String CONF_AUTHENTICATOR = "Authenticator";
    private static final String CONF_ADMINISTRATOR = "Administrator";
    
    
    private static URMUserDBManagerSpiJNDI mJndiAuthenticator = null;
    private URMConfigurator mAdministratorProperties = null;

    
    public URMAuthenticatorJNDI(URMConfigurator userdbConf) throws URMConfigurationException, URMAuthenticatorException {
        conf = userdbConf;
        if (userdbConf != null && !userdbConf.getName().equals(CONF_AUTHENTICATOR)) {
            Map mainprops = userdbConf.getSubConfigurators();
            conf = mainprops != null ? (URMConfigurator)mainprops.get(CONF_AUTHENTICATOR) : null;
        }
        if (conf == null)
            throw new URMConfigurationException(
                MessageLogger.getAndLogMessage(msLogger, "URMSUC0001", CONF_AUTHENTICATOR));
                
        mJndiAuthenticator = new URMUserDBManagerSpiJNDI(userdbConf);// just to read the configuration
        mAdministratorProperties = conf.getSubConfigurator(CONF_ADMINISTRATOR);
    }

    /* (non-Javadoc)
     * @see org.apache.slide.urm.authenticator.URMAuthenticator#authenticateUser(java.lang.String, char[])
     */
    public URMPrincipal authenticateUser(String user, char[] password) throws URMAuthenticationFailsException, URMAuthenticatorException, URMConfigurationException, URMCloseConnectionException {
        return this.authenticateUser(user, password, null);
    }

    /* (non-Javadoc)
     * @see org.apache.slide.urm.authenticator.URMAuthenticator#authenticateUser(java.lang.String, char[], java.lang.String)
     */
    public URMPrincipal authenticateUser(String user, char[] password, String domain) throws URMAuthenticationFailsException, URMAuthenticatorException, URMConfigurationException, URMCloseConnectionException {

        URMUserDBManagerSpiJNDI jndi_spi = mJndiAuthenticator.authenticateUser(user, new String(password));

        Object owner = new Object();
        URMAdministratorImpl admin = new URMAdministratorImpl(mAdministratorProperties, 
                                                            jndi_spi, owner);
                                                             
        URMAclAdministratorImpl acladmin = new URMAclAdministratorImpl(mAdministratorProperties, 
                                                                        null, null, null, owner);
        return new URMPrincipalImpl(user, password, domain, admin, acladmin);
    }

}
