/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/rolemanager/URMRoleAdministrator.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator.rolemanager;

import java.util.Set;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;

/**
 * The RoleManager allows to manage all roles.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMRoleAdministrator {

    /** Checks whether the role of a specific name exists.
     *
     * @param role name of a role that should be checked.
     * @return true if this is the name of an existing role.
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs.
     */
    public boolean isRole(String role)
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    /** Creates a new Role.
     * All role must have unique names.
     *
     * @param role name.
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs
     */
    public URMRole createRole(String role)
        throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException;
    
    /** Deletes the role of the given name and
     *  all occurrences of this role as ancestor.
     *
     * @param role name.
     * @return true if the role object was sucessfully removed.
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMInUseException if the Role is used in existing Ace's
     * @exception URMException if an unpredictable internal error occurs
     */
    public void deleteRole(String role)
        throws URMNotImplementedException, URMInternalServerException,
               URMForbiddenException,
               URMDeleteException, URMRoleInUseException;
    
    /** Returns the role object by a given name.
     *
     * @param role name of the role that should be returned
     * @return URMRole object.
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs
     */
    public URMRole getRole(String role)
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    /** Returns a set of all existing roles.
     *
     * @return set of roles.
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs
     */
    public Set getAllRoles()
        throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

}
