/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/rolemanager/impl/URMRoleAdminImpl.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator.rolemanager.impl;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMSubject;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleManagerSpi;
import org.apache.slide.urm.authenticator.userdb.URMMetadataPropsSpi;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManagerSpi;
import org.apache.slide.urm.common.URMConstants;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import org.apache.slide.urm.utils.validatorcache.URMListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

/**
 * RoleAdmin implementation class.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMRoleAdminImpl extends URMRoleImpl {
    
    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMRoleAdminImpl.class.getName());
   
    // get event listeners
    private URMListener aclListenerSet = URMListener.getAclListenerSet();
    
    public URMRoleAdminImpl(String roleName,
                            URMRoleManagerSpi roleManagerSpi,
                            URMUserDBManagerSpi userDBManagerSpi,
                            URMMetadataPropsSpi metadataPropsSpi) {
        super(roleName, roleManagerSpi, userDBManagerSpi, metadataPropsSpi);
    }


    /*public Set getRolesOfAncestor() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleAdminImpl.getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getRolesOfAncestor(mRoleName), mRoleManagerSpi, mUserDBManagerSpi, mMetadataPropsSpi);
    }*/

    public static Set getURMRoleObjectSetFromSubjectSet(Set rolenames,
                                                       URMRoleManagerSpi roleManagerSpi,
                                                       URMUserDBManagerSpi userDBManagerSpi,
                                                       URMMetadataPropsSpi metadataPropsSpi) {
        if (rolenames == null)
            return null;
        Iterator iter = rolenames.iterator();
        HashSet retusrs = new HashSet();
        while (iter.hasNext())
            retusrs.add(new URMRoleAdminImpl(((URMSubject)iter.next()).getName(), roleManagerSpi, userDBManagerSpi, metadataPropsSpi));
        return retusrs;
    }
    

    /*public Set getAncestors()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleAdminImpl.getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getAncestors(mRoleName), mRoleManagerSpi, mUserDBManagerSpi, mMetadataPropsSpi);
    }*/
    
 
    /*public Set getAllAncestors() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
         return URMRoleAdminImpl.getURMRoleObjectSetFromSubjectSet(mRoleManagerSpi.getAllAncestors(mRoleName), mRoleManagerSpi);
    }*/
    

    public void setProperties(Properties profile) throws URMUpdateException, URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        if (profile == null)
            mRoleManagerSpi.deleteProfileOfRole(mRoleName);
        
        if (mRoleManagerSpi != null) {
            Properties metaprops = new Properties();
            Set availablemetaprops = mRoleManagerSpi.getAvailableRolePropKeys();
            Set writeablemetaprops = mRoleManagerSpi.getWriteableRolePropKeys();
            for (Iterator keys = profile.keySet().iterator(); keys.hasNext();) {
                String key = (String)keys.next();
                if (availablemetaprops.contains(key)) {
                    if (writeablemetaprops.contains(key))
                        metaprops.setProperty(key, profile.getProperty(key));
                    else
                        throw new URMUpdateException(MessageLogger.getAndLogMessage(msLogger, "URMMPE0001", key));
                }
            }
            if (metaprops.size() > 0)
                mRoleManagerSpi.setProfileOfRole(mRoleName,profile);
        }
        else
            mRoleManagerSpi.setProfileOfRole(mRoleName,profile);
        
    }


//  public void deleteProfile() throws URMNotImplementedException, URMForbiddenException, URMUpdateException, URMInternalServerException {
//      mRoleManagerSpi.deleteProfileOfRole(mRoleName);
//
//  }


    public void setPredefinedAction(String action, Boolean type) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        if (action.equals(URMConstants.URM_ALL_ACTION)) throw new URMInsertException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0050"));
        mRoleManagerSpi.setPredefinedAction(mRoleName, action, type);
        aclListenerSet.resetEvent();
    }

    public void deletePredefinedAction(String action) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        mRoleManagerSpi.deletePredefinedAction(mRoleName, action);
        aclListenerSet.resetEvent();
    }

    public void addUserLink(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        mRoleManagerSpi.addUserLink(mRoleName, domain, user);
        aclListenerSet.resetEvent();
    }

    public void addGroupLink(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        mRoleManagerSpi.addGroupLink(mRoleName, domain, group);
        aclListenerSet.resetEvent();
    }

    public void addAncestor(String ancestor) throws URMNotImplementedException, URMForbiddenException,
                                                    URMInsertException, URMInternalServerException {
        mRoleManagerSpi.addAncestor(mRoleName, ancestor);
        aclListenerSet.resetEvent();
    }

    public void deleteUserLink(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        mRoleManagerSpi.deleteUserLink(mRoleName, user, domain);
        aclListenerSet.resetEvent();
    }

    public void deleteGroupLink(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        mRoleManagerSpi.deleteGroupLink(mRoleName, group, domain);
        aclListenerSet.resetEvent();
    }

    public void deleteAncestor(String ancestor) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        mRoleManagerSpi.deleteAncestor(mRoleName, ancestor);
        aclListenerSet.resetEvent();
    }


    /**
     * Sets new subject specific properties
     *
     * @param key property key
     * @param prop property value
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs
     */
    public void setProperty(String key, Object prop) throws URMNotImplementedException, URMForbiddenException, URMUpdateException , URMDeleteException, URMInternalServerException{
        Properties props = mRoleManagerSpi.getProfileOfRole(mRoleName);
        props.setProperty(key, (String) prop);
        setProperties(props);
                
    }
    
}


