/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/rolemanager/impl/URMRoleGuestImpl.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.authenticator.rolemanager.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.rolemanager.URMRole;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleManagerSpi;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import org.apache.slide.urm.authenticator.URMSubject;
import java.util.HashMap;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMRoleGuestImpl implements URMRole {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMRoleGuestImpl.class.getName());

    protected String mRoleName = null;
    protected URMRoleManagerSpi mRoleManagerSpi = null;

    public URMRoleGuestImpl(String roleName,
                       URMRoleManagerSpi roleManagerSpi) {
        mRoleName = roleName;
        mRoleManagerSpi = roleManagerSpi;
    }
    

    /* getDomain must return null.
     */
    public String getDomain() {
        return null;
    }
    

    public String getName() {
        return mRoleName;
    }

    public int getType() {
        return org.apache.slide.urm.common.URMConstants.ROLE;
    }

    /*
     * Retrieves a specific property
     */
    public Object getProperty(String key)throws URMNotImplementedException, URMForbiddenException,URMInternalServerException {
        Properties props = mRoleManagerSpi.getProfileOfRole(mRoleName);
        return props.getProperty(key);
    }
            
    /*
     * Retrieves a aggregated set of values of a specific property. The result set
     * contains the values of the property defined for the ancestors of the subject.
     */
    public Set getAggregatedProperty(String key) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        HashSet allProps = new HashSet();
        Object prop =  this.getProperty((String) key);
        if (prop != null)
            allProps.add(prop);
        for (Iterator iter = this.getAllAncestors().iterator(); iter.hasNext(); ) {
            prop = null;
            URMRole currentRole = (URMRole) iter.next();
            prop =  currentRole.getProperty((String) key);
            if (prop != null)
                allProps.add(prop);
        }
        
        return allProps;
    }

    public Set getRolesOfAncestor() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getRolesOfAncestor(mRoleName), mRoleManagerSpi);
    }

    public Map getPredefinedActions() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return mRoleManagerSpi.getPredefinedActions(mRoleName);
    }

    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj instanceof String)
            return mRoleName.equals((String)obj);
        if (obj instanceof URMRole)
            return mRoleName.equals(((URMRole)obj).getName());
        return false;
    }
    
    public int hashCode() {
        if (mRoleName != null)
            return mRoleName.hashCode();
         else
            return 0;
    }
    
    public static Set getURMRoleObjectSetFromSubjectSet(Set rolenames,
                                                    URMRoleManagerSpi roleManagerSpi) {
        if (rolenames == null)
            return null;
        Iterator iter = rolenames.iterator();
        HashSet retusrs = new HashSet();
        while (iter.hasNext())
            retusrs.add(new URMRoleGuestImpl(((URMSubject)iter.next()).getName(), roleManagerSpi));
        return retusrs;
    }
    
    public static boolean contains(Set roles, String role) {
        if (roles == null || role == null)
            return false;
        URMRole trole = new URMRoleImpl(role, null, null, null);
        return roles.contains(trole);
    }

    public Set getAncestors()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getAncestors(mRoleName), mRoleManagerSpi);
    }
   
    public Set getAllAncestors() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
         return getURMRoleObjectSetFromSubjectSet(mRoleManagerSpi.getAllAncestors(mRoleName), mRoleManagerSpi);
    }
 
    public Properties getProperties()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return mRoleManagerSpi.getProfileOfRole(mRoleName);
    }

    public Set getUserMapping()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public Set getGroupMapping()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }
  
    public void setProperties(Properties profile)
        throws URMNotImplementedException, URMForbiddenException,
        URMUpdateException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void setPredefinedAction(String action, Boolean type) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deletePredefinedAction(String action) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void addUserLink(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void addGroupLink(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInsertException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void addAncestor(String ancestor) throws URMNotImplementedException, URMForbiddenException,
                                                    URMInsertException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteUserLink(String user, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteGroupLink(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    public void deleteAncestor(String ancestor) throws URMNotImplementedException, URMForbiddenException, URMDeleteException, URMInternalServerException {
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }

    /**
     * Sets new subject specific properties
     *
     * @param key property key
     * @param prop property value
     *
     * @exception URMNotImplementedException if the method is not
     *            implemented by the user database.
     * @exception URMForbiddenException if the user has not the permission
     *            to invoke the method.
     * @exception URMException if an unpredictable internal error occurs
     */
    public void setProperty(String key, Object prop)
    throws URMNotImplementedException, URMForbiddenException,
           URMUpdateException , URMDeleteException, URMInternalServerException{
        throw new URMForbiddenException(MessageLogger.getAndLogMessage(msLogger, "URMCOE0027"));
    }
    
    /** Returns key, value pairs where the key is the name of available
     * propery and the value is a java.lang.Boolean object which is true
     * if the property can be modified (writeable flag).
     *
     * @return a Map containing property name and writeable flag pairs
     */
    public Map getAvailablePropertyNames() throws URMForbiddenException {
        Map map = new HashMap();
        Object obj = null;
        // property names from metaprops spi
        Set props = mRoleManagerSpi.getWriteableRolePropKeys();
        for (Iterator iter = props.iterator(); iter.hasNext();)
            map.put(iter.next(), Boolean.TRUE);
        props = mRoleManagerSpi.getAvailableRolePropKeys();
        for (Iterator iter = props.iterator(); iter.hasNext();)
            if (!map.containsKey(obj = iter.next()))
                map.put(obj, Boolean.FALSE);
        return map;
    }
}
