/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/rolemanager/impl/URMRoleImpl.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator.rolemanager.impl;

import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.rolemanager.URMRoleManagerSpi;
import org.apache.slide.urm.authenticator.userdb.URMMetadataPropsSpi;
import org.apache.slide.urm.authenticator.userdb.URMUserDBManagerSpi;
import org.apache.slide.urm.authenticator.userdb.impl.URMGroupImpl;
import org.apache.slide.urm.authenticator.userdb.impl.URMUserImpl;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.authenticator.URMSubject;

/**
 * Implementation of the Role interface.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMRoleImpl extends URMRoleGuestImpl {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMRoleImpl.class.getName());
    
    protected URMUserDBManagerSpi mUserDBManagerSpi = null;
    protected URMMetadataPropsSpi mMetadataPropsSpi = null;

    public URMRoleImpl(String roleName,
                       URMRoleManagerSpi roleManagerSpi,
                       URMUserDBManagerSpi UserDBManagerSpi,
                       URMMetadataPropsSpi MetadataPropsSpi) {
        super (roleName, roleManagerSpi);
        mUserDBManagerSpi = UserDBManagerSpi;
        mMetadataPropsSpi = MetadataPropsSpi;
    }

    /*public Set getRolesOfAncestor() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleImpl.getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getRolesOfAncestor(mRoleName), mRoleManagerSpi);
    }*/


    /*public Set getAncestors()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMRoleImpl.getURMRoleObjectSetFromSubjectSet(
                    mRoleManagerSpi.getAncestors(mRoleName), mRoleManagerSpi);
    }*/

    /*public Set getAllAncestors() throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
         return URMRoleImpl.getURMRoleObjectSetFromSubjectSet(mRoleManagerSpi.getAllAncestors(mRoleName), mRoleManagerSpi);
    }*/
 
    public Set getUserMapping()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMUserImpl.getURMUserObjectSetFromSubjectSet(
                                    mRoleManagerSpi.getUserMappingOfRole(mRoleName),
                                    mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);
    }

    public Set getGroupMapping()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException {
        return URMGroupImpl.getURMGroupObjectSetFromSubjectSet(
                                            mRoleManagerSpi.getGroupMappingOfRole(mRoleName),
                                            mUserDBManagerSpi, mMetadataPropsSpi, mRoleManagerSpi);

    }

    public static Set getURMRoleObjectSetFromSubjectSet(Set rolenames,
                                                    URMRoleManagerSpi roleManagerSpi,
                                                    URMUserDBManagerSpi UserDBManagerSpi,
                                                    URMMetadataPropsSpi MetadataPropsSpi) {
        if (rolenames == null)
            return null;
        Iterator iter = rolenames.iterator();
        HashSet retusrs = new HashSet();
        while (iter.hasNext())
            retusrs.add(new URMRoleImpl(((URMSubject)iter.next()).getName(), roleManagerSpi, UserDBManagerSpi, MetadataPropsSpi));
        return retusrs;
    }
    
    public static Set getURMRoleObjectSetFromStringSet(Set rolenames,
                                                    URMRoleManagerSpi roleManagerSpi,
                                                    URMUserDBManagerSpi UserDBManagerSpi,
                                                    URMMetadataPropsSpi MetadataPropsSpi) {
        if (rolenames == null)
            return null;
        Iterator iter = rolenames.iterator();
        HashSet retusrs = new HashSet();
        while (iter.hasNext())
            retusrs.add(new URMRoleImpl((String)iter.next(), roleManagerSpi, UserDBManagerSpi, MetadataPropsSpi));
        return retusrs;
    }

}


