/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/userdb/URMMetadataPropsSpi.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.authenticator.userdb;

import java.util.Properties;
import java.util.Set;

import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.authenticator.URMDBTransactionException;
import org.apache.slide.urm.common.URMCloseConnectionException;
import org.apache.slide.urm.common.URMConnectionException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;

/**
 * Service Provider Interface definition to access the MataData properties.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMMetadataPropsSpi {

    /**
     * @param name
     * @param domain
     * @param isUser
     * @return Properties
     * @throws URMForbiddenException
     * @throws URMInternalServerException
     */
    public Properties getProperties(String name, String domain, boolean isUser)
        throws URMForbiddenException, URMInternalServerException;
    
    /** Sets the properties of the specified userdb entry.
     * Empty property value means deleting the property entry.
     * @param name
     * @param domain
     * @param props
     * @param isUser
     * @throws URMNotImplementedException
     * @throws URMForbiddenException
     * @throws URMUpdateException
     * @throws URMInternalServerException
     */
    public void setProperties(String name, String domain, Properties props, boolean isUser)
        throws URMNotImplementedException, URMForbiddenException, URMUpdateException,
                URMDeleteException, URMInternalServerException;
        
    
    /**
     * Method deletes the properties of the passed user
     *
     * @param    user                a  String
     * @param    domain              a  String
     *
     * @throws   URMDeleteException
     * @throws   URMInternalServerException
     *
     */
    public void deleteProperiesOfUser(String user, String domain) throws URMDeleteException, URMInternalServerException;
    
    /**
     * Method deletes the properties of the passed group
     *
     * @param    group               a  String
     * @param    domain              a  String
     *
     * @throws   URMDeleteException
     * @throws   URMInternalServerException
     *
     */
    public void deleteProperiesOfGroup(String group, String domain) throws URMDeleteException, URMInternalServerException;
    
    /** Returns the writeable metaproperties of the users.
     *
     * @return Set
     */
    public Set getWriteableUserPropKeys();

    /** Returns all the available metaproperties of the users.
     *
     * @return Set
     */
    public Set getAvailableUserPropKeys();
    
    /** Returns the writeable metaproperties of the groups.
     *
     * @return Set
     */
    public Set getWriteableGroupPropKeys();

    /** Returns all the available metaproperties of the groups.
     *
     * @return Set
     */
    public Set getAvailableGroupPropKeys();
     
    /** Removes the needless entries from the metaproperties.
     *  It checks which users and groups were removed from the user database and
     *  removes the belonging entries from the metaproperties.
     *
     * @throws URMNotImplementedException
     * @throws URMForbiddenException
     * @throws URMInternalServerException
     * @throws URMDeleteException
     */
    public void syncronizeUsersGroupsRoles(String domain, Set existingUsers, Set existingGroups)
            throws URMDeleteException, URMNotImplementedException, URMForbiddenException, URMInternalServerException;
            
    public Set getAvailableDomains() throws URMInternalServerException;
        
    public URMMetadataPropsSpi duplicateObject(Object owner) throws URMConnectionException;
        
    /** Closes the connection to the database.
     * @throws URMCloseConnectionException
     */
    public void close() throws URMCloseConnectionException;
    
    public void beginTransaction()
        throws URMDBTransactionException, URMInternalServerException;

    public void endTransaction(boolean manner)
        throws URMDBTransactionException, URMInternalServerException;
}




