/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/authenticator/userdb/URMUserDBManagerSpi.java,v 1.4 2005/03/02 10:53:34 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:34 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.authenticator.userdb;

import java.util.*;
import org.apache.slide.urm.URMForbiddenException;
import org.apache.slide.urm.URMNotImplementedException;
import org.apache.slide.urm.common.URMCloseConnectionException;
import org.apache.slide.urm.common.URMDeleteException;
import org.apache.slide.urm.common.URMInsertException;
import org.apache.slide.urm.common.URMInternalServerException;
import org.apache.slide.urm.common.URMUpdateException;

/**
 * Service Provider Interface definition to access the UserDBManager (SSX)
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMUserDBManagerSpi {

    public Set getAllGroups()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Set getAllGroups(String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Set getAllUsers()
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Set getAllUsers(String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Set getGroupsOfUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    /**
     * The list begins with the groups then a null entry and then the users.
     *
     */
    public List getGroupMembers(String group)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public List getGroupMembers(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
            
    public Set getGroupsMemberOf(String group)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
            
    public Set getGroupsMemberOf(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
  
    public void createUser(String user, char[] password, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;

    public void createGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;

    public void deleteUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;

    public void deleteGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;

    public Properties getUserProperties(String user)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Properties getUserProperties(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    public void setUserProperties(String user, Properties props)
            throws URMNotImplementedException, URMForbiddenException, URMUpdateException;

    public Properties getGroupProperties(String group) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public Properties getGroupProperties(String group, String domain) throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;

    public void setGroupProperties(String group, Properties props) throws URMNotImplementedException, URMForbiddenException, URMUpdateException;
    
    public void setGroupProperties(String group, String domain, Properties props) throws URMNotImplementedException, URMForbiddenException, URMUpdateException;
    
    public void setUserProperties(String user, String domain, Properties props)
            throws URMNotImplementedException, URMForbiddenException, URMUpdateException;
    
    public void addUserToGroup(String user, String group)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;
    
    public void addUserToGroup(String user, String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;
    
    public void removeUserFromGroup(String user, String group)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;
    
    public void removeUserFromGroup(String user, String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;

    public void addGroupToGroup(String memberGroup, String toGroup)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;
    
    public void addGroupToGroup(String memberGroup, String toGroup, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInsertException;
    
    public void removeGroupFromGroup(String memberGroup, String fromGroup)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;
    
    public void removeGroupFromGroup(String memberGroup, String fromGroup, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMDeleteException;

    public void changeUserPassword(String user, char[] oldpassword, char[] newpassword)
            throws URMNotImplementedException, URMForbiddenException, URMUpdateException;
    
    public void changeUserPassword(String user, String domain, char[] oldpassword, char[] newpassword)
            throws URMNotImplementedException, URMForbiddenException, URMUpdateException;
    
    public boolean isUser(String user)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    public boolean isUser(String user, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    public boolean isGroup(String group)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    public boolean isGroup(String group, String domain)
            throws URMNotImplementedException, URMForbiddenException, URMInternalServerException;
    
    public void close() throws URMCloseConnectionException;
    
    /** Clears the caches.
     *
     */
    public void clearCaches();
    
    
    /** Returns the writeable metaproperties.
     *
     * @param isUser if true than it returns the writeable user metaproperties
     *                  otherwise the writeable group metaproperties
     * @return Set
     */
    public Set getWriteablePropKeys(boolean isUser);

    /** Returns all the available metaproperties.
     *
     * @param isUser if true than it returns the writeable user metaproperties
     *                  otherwise the writeable group metaproperties
     * @return Set
     */
    public Set getAvailablePropKeys(boolean isUser);
     
}


