/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/common/URMConfigurator.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.common;

import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.URMNotImplementedException;

/**
 * It is used collect configuration for several tools.
 * A possible (recursive) implementation can use a xml file
 * to load the data from.
 * In this case the getProperties() could return
 * attribute node name and value pairs of the current xml node and the
 * {getSubProperties() could return a subnode (that has the name specified in the String parameter)
 * represented by another URMConfiurator object.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public interface URMConfigurator {

    /**
     * Returns the subject name of the configurator.
     *
     * @return the subject name of the configurator
     */
    public String getName();

    /**
     * Returns the global properties.
     *
     * @return the required Properties or null if it does not exist
     */
    public Properties getProperties();
    
    /**
     * Returns subproperties.
     *
     * @return the required Properties or null if it does not exist
     */
    public Map getSubConfigurators();

    /**
     * Returns subconfigurator.
     *
     * @return the required URMConfigurator or null if it does not exist
     */
    public URMConfigurator getSubConfigurator(String key);
    
    /**
     * Returns the root configurator.
     *
     * @return the required URMConfigurator or null if it does not exist
     */
    public URMConfigurator getRootConfigurator();
    
    /** Maps the specified key to the specified value.
     *  Neither the key nor the value can be null.
     *
     * @param key
     * @param value
     * @return the previous value of the specified key in this
     *          property list, or null if it did not have one.
     */
    public String setPropery(String key, String value);
    
    /** Sets the subconfigurator to the current one. If the name of the
     *  subconfigurator is null than it does not add the specified object.
     *
     * @param subConf
     * @return the previous value of the specified key in this
     *          property list, or null if it did not have one.
     */
    public URMConfigurator setSubConfigurator(URMConfigurator subConf);

    /** Adds the subconfigurator to the current one. If the name of the
     *  subconfigurator is null than it does not add the specified object.
     *
     * @return the previous value of the specified key in this
     *          property list, or null if it did not have one.
     */
    public void addSubConfigurator(String name, Properties props);
        
    /** Removes the secified subconfigurator.
     *
     * @param subConfName
     * @return the value to which the key had been mapped in this
     *          hashtable, or null if the key did not have a mapping.
     */
    public URMConfigurator removeSubConfigurator(String subConfName);
    
    /** Parses the configurator to an output stream.
     *
     * @param outstream is the output stream of the configurator
     */
    public void getConfiguratorAsStream(OutputStream outstream) throws URMNotImplementedException, URMException;
    
    /**
     * Returns a string representation of this configurator.
     *
     * @return a string representation of this configurator
     */
    public String toString();
}
