/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/common/impl/URMConfiguratorUtil.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.common.impl;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.slide.urm.common.URMConfigurator;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;

/**
 * Helper to maintain the configuration file.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
public class URMConfiguratorUtil {
    
    public static final String CONF_ATTRIBUTES = "Attributes";
    public static final String CONF_ATTRIBUTE  = "Attribute";
    public static final String CONF_PROPERTIES = "Properties";
    public static final String CONF_PROPERTY   = "Property";

    public static Iterator getAttributeList(URMConfigurator classConf, org.apache.log4j.Logger logger) {
        if (classConf == null)
            return null;
        Map attrprops = classConf.getSubConfigurators();
        if (attrprops == null) {
            MessageLogger.logMessage(logger, "URMCOW0003", classConf.getName(), "root");
            return null;
        }
                
        Object obj = attrprops.get(CONF_ATTRIBUTES);
        obj = obj != null ? ((URMConfigurator)obj).getSubConfigurators().get(CONF_ATTRIBUTE) : null;
        if (obj == null) {
            MessageLogger.logMessage(logger, "URMCOW0003", CONF_ATTRIBUTES, classConf.getName());
            return null;
        }
                
        Iterator attrs = null;
        if (obj instanceof List)
            attrs = ((List)obj).iterator();
        else { // it happends usually not
            LinkedList list = new LinkedList();
            list.addFirst(obj);
            attrs = list.iterator();
        }

        return attrs;
    }
    
    public static Iterator getPropertyList(URMConfigurator classConf, org.apache.log4j.Logger logger) {

        Map attrprops = classConf.getSubConfigurators();
        if (attrprops == null) {
            MessageLogger.logMessage(logger, "URMCOW0003", classConf.getName(), "root");
            return null;
        }
                
        Object obj = attrprops.get(CONF_PROPERTY);
        if (obj == null) {
            MessageLogger.logMessage(logger, "URMCOW0003", CONF_PROPERTIES, classConf.getName());
            return null;
        }
                
        Iterator props = null;
        if (obj instanceof List)
        props = ((List)obj).iterator();
        else { // it happends usually not
            LinkedList list = new LinkedList();
            list.addFirst(obj);
            props = list.iterator();
        }

        return props;
    }

    public static Properties getNodeAttrsAsProperties(URMConfigurator conf,
                                    String nodeName, String keyAttr, String valueAttr) {
    
        Map propnodes = conf.getSubConfigurators();
        if (propnodes == null)
            return null;
        Object obj = propnodes.get(nodeName);
        if (obj == null)
            return null;
        if (obj instanceof URMConfigurator) {
            Properties props = new Properties();
            Properties subprops = ((URMConfigurator)obj).getProperties();
            if (subprops == null)
                return null;
            String key = subprops.getProperty(keyAttr);
            String val = subprops.getProperty(valueAttr);
            if (key != null && val != null) {
                props.setProperty(key, val);
                return props;
            }
            else
                return null;
        }
            
        if (!(obj instanceof List) )
            return null;
        List list = (List)obj;
        Iterator iter = list.iterator();
        Properties props = new Properties();
        while (iter.hasNext()){
            obj = iter.next();
            if (!(obj instanceof URMConfigurator))
                continue;
            Properties subprops = ((URMConfigurator)obj).getProperties();
            if (subprops == null)
                continue;
            String key = subprops.getProperty(keyAttr);
            String val = subprops.getProperty(valueAttr);
            if (key != null && val != null)
                props.setProperty(key, val);
        }
        if (props.size() > 0)
            return props;
        else
            return null;
    }
}
