/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/common/impl/tamino/URMTaminoConnection.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.common.impl.tamino;

import java.util.HashMap;
import java.util.Map;

import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;

/**
 *
 * Object that reflects a Tamino connection.
 * We have one connection per Principal instance per thread.
 * Transaction status and
 * flags for updating the caches is maintained here.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 *
 */
public class URMTaminoConnection {

    private static final int UPDATE = 1;
    private static final int QUERY = 2;
    private static final int START_TA = 3;
    private static final int COMMIT_TA = 4;
    private static final int ROLLBACK_TA = 5;

    private int mThreadLevel = 0;
    private TLocalTransaction mTransaction = null;
    private TXMLObjectAccessor mAccessor = null;
    private int mMode = 0;
    private TConnection mConnection = null;
    private boolean mInTA = false;
    private boolean mAccessCache = true;
    private Map mActionDeltaCache = null;
    private Map mAclDeltaCache = null;
    
    public URMTaminoConnection() {
        
    }
    
    public void add(int threadLevel,
                    int mode,
                    TConnection conn,
                    TXMLObjectAccessor accessor,
                    TLocalTransaction locTrans) {
        mThreadLevel = threadLevel;
        mMode = mode;
        mConnection = conn;
        mAccessor = accessor;
        mTransaction = locTrans;
        
        if (mode == START_TA && threadLevel == 0){
            mInTA = true;
        } else {
            mInTA = false;
        }
        
        if (mInTA == true && mode == UPDATE) {
            mAccessCache = false;
        } else {
            mAccessCache = true;
        }
    }
    
    public int getThreadLevel(){
        return mThreadLevel;
    }
    
    public TLocalTransaction getTransaction(){
        return mTransaction;
    }
    
    public TXMLObjectAccessor getAccessor(){
        return mAccessor;
    }
    
    public int getMode(){
        return mMode;
    }
    
    public TConnection getConnection(){
        return mConnection;
    }
    
    public void setThreadLevel(int threadLevel){
        mThreadLevel = threadLevel;
    }
    
    public void endUserTA() {
        mInTA = false;
        mAccessCache = true;
    }
    
    public void updateMethod(){
        if (mInTA == true){
            mAccessCache = false;
        }
    }
    
    public boolean accessCache(){
        return mAccessCache;
    }
    
    public void createDeltaCaches(){
        mActionDeltaCache = new HashMap();
        mAclDeltaCache = new HashMap();
    }

    public Map getActionDeltaCache(){
        return mActionDeltaCache;
    }

    public Map getAclDeltaCache(){
        return mAclDeltaCache;
    }
}
