/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/URMClassInstantiator.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.urm.utils;

import org.apache.slide.urm.URMException;
import org.apache.slide.urm.utils.messagelogger.MessageLogger;
import java.util.Hashtable;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class URMClassInstantiator {

    private static org.apache.log4j.Logger msLogger =
        org.apache.log4j.Logger.getLogger(URMClassInstantiator.class.getName());


    private static final Hashtable classCache = new Hashtable();

    public static Object newInstance(String className, Object params[])
        throws URMException {

        if (msLogger.isInfoEnabled())
            MessageLogger.logMessage(msLogger, "URMCOI0021", className);
        ClassLoader classloader = URMClassInstantiator.class.getClassLoader();
        Class spiClass = (Class)classCache.get(className);

        if (spiClass == null) {
            try {
                if (classloader == null) {
                    spiClass = Class.forName(className);
                } else {
                    spiClass = classloader.loadClass(className);
                }
                classCache.put(className, spiClass);
            } catch (ClassNotFoundException e) {
                throw new URMException(
                    MessageLogger.getAndLogMessage(msLogger, "URMCOC0020", className));
            }
        }

        java.lang.reflect.Constructor constructs[] = spiClass.getConstructors();

        if (msLogger.isInfoEnabled())
            MessageLogger.logMessage(msLogger, "URMCOI0022", className);

        for (int i = 0; i < constructs.length; ++i)
            if (constructs[i].getParameterTypes().length == params.length) {
                try {
                    return constructs[i].newInstance(params);
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new URMException(
                        MessageLogger.getAndLogMessage(msLogger, "URMCOC0023",
                                                       className, e.getClass().getName(), e.getMessage()));
                }
            }

        throw new URMException(
            MessageLogger.getAndLogMessage(msLogger, "URMCOC0020", className));
    }
}
