/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/messagelogger/MessageLogger.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.messagelogger;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

import org.apache.log4j.Logger;
import org.apache.log4j.Level;
import org.apache.slide.urm.utils.resourceutilities.message.XMLMessageResourceBundle;
import org.apache.slide.urm.utils.resourceutilities.message.ResourceMessage;
import org.apache.slide.urm.utils.resourceutilities.message.MessageCode;
import org.apache.slide.urm.utils.resourceutilities.message.DefaultMessage;
import org.apache.slide.urm.utils.resourceutilities.message.MessageRetrieveException;

import java.util.ResourceBundle;


public class MessageLogger
{
    static {
        init();
    }
    
    private static ResourceBundle mResourceBundle;
        
    private static synchronized void init() {
        init("org.apache.slide.urm.utils.messagelogger.URMMessages");
    }
    
    public static synchronized void init(String xmlMessagesFile) {
        //ClassLoader cl = ClassLoader.getSystemClassLoader();
        //System.out.println(cl.getClass().getName());
        mResourceBundle = XMLMessageResourceBundle.getBundle(xmlMessagesFile, null, null);
    }
    
    public static void logMessage(Logger logger, String level, Throwable exception) {
        if (logger.isDebugEnabled())
            logMessageText(level, "(" + exception.getClass().getName() + ") - " +
                         exception.getMessage(), logger);
    }
    
    public static String getAndLogMessage(Logger logger, String level, Throwable exception) {
        logMessageText(level, "(" + exception.getClass().getName() + ") - " +
                     exception.getMessage(), logger);
        return exception.getMessage();
    }
    
    public static void logMessage(Logger logger, String messageId) {
        if (logger.isDebugEnabled())
            logMessage(messageId, null, logger);
    }
    
    public static String getAndLogMessage(Logger logger, String messageId) {
        String msg = getMessage(messageId, null);
        logMessageText(messageId, msg, logger);
        return msg;
    }
    
    public static void logMessage(Logger logger, String messageId, Object param1) {
        if (!logger.isDebugEnabled())
            return;
        Object params[] = {param1};
        logMessage(messageId, params, logger);
    }
    
    public static String getAndLogMessage(Logger logger, String messageId, Object param1) {
        Object params[] = {param1};
        String msg = getMessage(messageId, params);
        logMessageText(messageId, msg, logger);
        return msg;
    }
    
    public static void logMessage(Logger logger, String messageId, Object param1,
                                    Object param2) {
        if (!logger.isDebugEnabled())
            return;
        Object params[] = { param1, param2 };
        logMessage(messageId, params, logger);
    }
    
    public static String getAndLogMessage(Logger logger, String messageId, Object param1,
                                    Object param2) {
        Object params[] = { param1, param2 };
        String msg = getMessage(messageId, params);
        logMessageText(messageId, msg, logger);
        return msg;
    }
    
    public static void logMessage(Logger logger, String messageId, Object param1,
                                    Object param2, Object param3) {
        if (!logger.isDebugEnabled())
            return;
        Object params[] = { param1, param2, param3 };
        logMessage(messageId, params, logger);
    }
    
    public static String getAndLogMessage(Logger logger, String messageId, Object param1,
                                    Object param2, Object param3) {
        Object params[] = { param1, param2, param3 };
        logMessage(messageId, params, logger);
        String msg = getMessage(messageId, params);
        logMessageText(messageId, msg, logger);
        return msg;
    }
    
    public static void logMessage(Logger logger, String messageId, Object param1,
                                    Object param2, Object param3, Object param4) {
        if (!logger.isDebugEnabled())
            return;
        Object params[] = { param1, param2, param3, param4 };
        logMessage(messageId, params, logger);
    }
    
    public static String getAndLogMessage(Logger logger, String messageId, Object param1,
                                    Object param2, Object param3, Object param4) {
        Object params[] = { param1, param2, param3, param4 };
        String msg = getMessage(messageId, params);
        logMessageText(messageId, msg, logger);
        return msg;
    }
    
    public static String getMessage(String messageId, Object[] params) {
        try {
            if( params == null ) {
                return (new ResourceMessage( mResourceBundle, messageId)).getMessageContent();
            } else {
                return (new ResourceMessage( mResourceBundle, messageId, params)).getMessageContent();
            }
        } catch (MessageRetrieveException messageRetrieveException) {
            return (new DefaultMessage( new MessageCode( messageId ), null,
                "Could not retrieve the message code " + messageId)).getMessageContent();
        }
    }
        
    private static void logMessage(String messageId, Object[] params, Logger logger) {
        int ilevel = Level.OFF_INT;
        switch (messageId.length() > 4 ? messageId.charAt(5) : messageId.charAt(0)) {
            case 'D': // debug
            case 'Q': // debug
                ilevel = Level.DEBUG_INT;
                break;
            case 'I': // info
                ilevel = Level.INFO_INT;
                break;
            case 'W': // warning
                ilevel = Level.WARN_INT;
                break;
            case 'E': // error
                ilevel = Level.ERROR_INT;
                break;
            case 'F': // fatal
            case 'C': // fatal (critical)
                ilevel = Level.FATAL_INT;
                break;
            default:
                logger.fatal("Message(" + messageId +
                    ") with unknown level: " + getMessage(messageId, params));
                return;
        }
        Level msglev = Level.toLevel(ilevel);
        if (logger.isEnabledFor(msglev))
            // getMessageText() is not called if the message need not to be logged
            logger.log(msglev, getMessage(messageId, params));
    }
    
    private static void logMessageText(String messageId, String messageText, Logger logger) {
        switch (messageId.length() > 4 ? messageId.charAt(5) : messageId.charAt(0)) {
            case 'D': // debug
            case 'Q': // debug
                logger.debug(messageText);
                break;
            case 'I': // info
                logger.info(messageText);
                break;
            case 'W': // warning
                logger.warn(messageText);
                break;
            case 'E': // error
                logger.error(messageText);
                break;
            case 'F': // fatal
            case 'C': // fatal (critical)
                logger.fatal(messageText);
                break;
            default:
                logger.fatal("Message(" + messageId + ") with unknown level: " + messageText);
                break;
        }
    }
}

