/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/XMLResourceBundleFailureHandler.java,v 1.4 2005/03/02 10:53:35 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities;

// import list
import org.apache.slide.urm.utils.resourceutilities.ResourceLocator.ResourceLocation;

import java.io.IOException;

import java.util.Locale;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

/**
 ** A <code>XMLResourceBundleFailureHandler</code> may be passed to a subclass of
 ** in order to handle failures that might occur when
 ** retrieving and parsing the XML document.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public interface XMLResourceBundleFailureHandler {
    
    /**
     ** Handles the case that a resource file for the given <code>baseName</code>
     ** was not found.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      baseName     the base name of the resource (without extension).
     ** @param      locale       the desrired Locale. May be <code>null</code>.
     ** @param      classLoader  the ClassLoader to load the resource from. May be <code>null</code>.
     **/
    public void handleResourceBundleNotFound(String baseName, Locale locale, ClassLoader classLoader);
    
    /**
     ** Handles a ParserConfigurationException that occurred when parsing the XML file.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      exception         the ParserConfigurationException that occurred.
     ** @param      resourceLocation  the location of the resource.
     **/
    public void handleParseException(ParserConfigurationException exception, ResourceLocation resourceLocation);
    
    /**
     ** Handles a SAXException that occurred when parsing the XML file.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      exception  the SAXException that occurred.
     ** @param      resourceLocation  the location of the resource.
     **/
    public void handleParseException(SAXException exception, ResourceLocation resourceLocation);
    
    /**
     ** Handles a IOException that occurred when parsing the XML file.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      exception  the IOException that occurred.
     ** @param      resourceLocation  the location of the resource.
     **/
    public void handleParseException(IOException exception, ResourceLocation resourceLocation);
}

