/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/AbstractDetailedMessage.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

// import list
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 ** This class extends {@link AbstractDetailedMessage AbstractDetailedMessage}
 ** by the methods defined by the {@link DetailedMessage DetailedMessage} interface.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public abstract class AbstractDetailedMessage extends AbstractMessage implements DetailedMessage {

	/**
	 ** The details returned by {@link #getDetails getDetails()}.
	 **/
	protected String details = null;
	
	
	
	/**
	 ** Returns the details of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the details of the message.
	 **/
	public String getDetails() {
		return details;
	}
	
	/**
	 ** Sets the details of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      details  the details of the message.
	 **/
	protected void setDetails(String details) {
		this.details = details;
	}

	/**
	 ** Returns an XML representation of the message where the given
	 ** <code>document</code> is used to create the Element(s).
	 ** <code>Null</code> values are represented by omitting the corresponding Element.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      document  the Document that is used to create the Element(s).
	 **
	 ** @return     an XML representation of the message.
	 **
	 ** @see        MessageConstants
	 **/
	public Element toXML(Document document) {
		
		Element messageElement = super.toXML(document);
		
		if (getDetails() != null) {
			messageElement.appendChild(createElementWithText(document,
															 DETAILS_TAG_NAME,
															 getDetails()));
		}
		
		return messageElement;
	}
	
}

