/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/AbstractMessage.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

// import list
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 ** This class is intended to be the base for all Message implementations and
 ** provides an implementation of the {@link #toXML toXML()} method.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public abstract class AbstractMessage implements Message, MessageConstants {
	
	/**
	 ** Enables/disables precondition testing due to a global setting.
	 **/
	//zsa//private static final boolean PRE_CHECK = Precondition.isEnabled(AbstractMessage.class);
	
	/**
	 ** Enables/disables postcondition testing due to a global setting.
	 **/
	//zsa//private static final boolean POST_CHECK = Postcondition.isEnabled(AbstractMessage.class);
	
	
	/**
	 ** The DocumentBuilder used to create Documents.
	 **/
	protected static DocumentBuilder documentBuilder = null;
	
	
	
	
	/**
	 ** Returns an XML representation of the message.
	 ** <code>Null</code> values are represented by omitting the corresponding Element.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     an XML representation of the message.
	 **
	 ** @throws     ParserConfigurationException if instantiation of a DocumentBuilder
	 **                                          failed (which is needed to create
	 **                                          the Document).
	 **
	 ** @see        MessageConstants
	 **/
	public Document toXML() throws ParserConfigurationException {
		
		Document document = getDocumentBuilder().newDocument();
		toXML(document);
		return document;
	}
	
	
	/**
	 ** Returns an XML representation of the message where the given
	 ** <code>document</code> is used to create the Element(s).
	 ** <code>Null</code> values are represented by omitting the corresponding Element.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      document  the Document that is used to create the Element(s).
	 **
	 ** @return     an XML representation of the message.
	 **
	 ** @see        MessageConstants
	 **/
	public Element toXML(Document document) {
		
		Element messageElement = document.createElement(MESSAGE_TAG_NAME);
		document.appendChild(messageElement);
		
		if (getMessageCode() != null) {
			messageElement.appendChild(createElementWithText(document,
															 CODE_TAG_NAME,
															 getMessageCode().toString()));
		}
		
		if (getMessageTitle() != null) {
			messageElement.appendChild(createElementWithText(document,
															 TITLE_TAG_NAME,
															 getMessageTitle()));
		}
		
		if (getMessageContent() != null) {
			messageElement.appendChild(createElementWithText(document,
															 CONTENT_TAG_NAME,
															 getMessageContent()));
		}
		
		if ( (getExplanationTitle() != null) || (getExplanationContent() != null) ) {
			Element explanationElement = document.createElement(EXPLANATION_TAG_NAME);
			messageElement.appendChild(explanationElement);
			if (getExplanationTitle() != null) {
				explanationElement.appendChild(createElementWithText(document,
																	 TITLE_TAG_NAME,
																	 getExplanationTitle()));
			}
			if (getExplanationContent() != null) {
				explanationElement.appendChild(createElementWithText(document,
																	 CONTENT_TAG_NAME,
																	 getExplanationContent()));
			}
		}
		
		if ( (getActionTitle() != null) || (getActionContent() != null) ) {
			Element actionElement = document.createElement(ACTION_TAG_NAME);
			messageElement.appendChild(actionElement);
			if (getActionTitle() != null) {
				actionElement.appendChild(createElementWithText(document,
																TITLE_TAG_NAME,
																getActionTitle()));
			}
			if (getActionContent() != null) {
				actionElement.appendChild(createElementWithText(document,
																CONTENT_TAG_NAME,
																getActionContent()));
			}
		}
		
		if (getHelpID() != null) {
			messageElement.appendChild(createElementWithText(document,
															 HELP_ID_TAG_NAME,
															 getHelpID()));
		}
		
		return messageElement;
	}
	
	
	
	/**
	 ** Creates an Element node with the given <code>tagName</code> which has
	 ** a Text node child with the given <code>text</code> as value.
	 **
	 ** @pre        document != null
	 ** @pre        tagName != null
	 ** @pre        text != null
	 ** @post       return != null
	 **
	 ** @param      document  the Document of the Element to create.
	 ** @param      tagName   the name of the Element to create.
	 ** @param      text      the value of the child Text node of the Element.
	 **
	 ** @return     the created Element.
	 **/
	protected static Element createElementWithText(Document document, String tagName, String text) {
		
		//zsa//if (PRE_CHECK) {Precondition.check("Parameter 'document' must not be null", document != null);}
		//zsa//if (PRE_CHECK) {Precondition.check("Parameter 'tagName' must not be null", tagName != null);}
		//zsa//if (PRE_CHECK) {Precondition.check("Parameter 'text' must not be null", text != null);}
		
		Element element = document.createElement(tagName);
		element.appendChild(document.createTextNode(text));
		return element;
	}
	
	
	
	/**
	 ** Returns the DocumentBuilder used to create Documents.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the DocumentBuilder used to create Documents.
	 **
	 ** @throws     ParserConfigurationException if a DocumentBuilder could
	 **                                          not be created.
	 **/
	protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
		
		if (documentBuilder == null) {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			documentBuilder = factory.newDocumentBuilder();
		}
		return documentBuilder;
	}
	
	
}

