/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/DefaultMessage.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

/**
 ** A default implementation of the DetailedMessage interface which allows you
 ** to set the values directly instead of using a ResourceBundle.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public class DefaultMessage extends AbstractDetailedMessage {
	
	/**
	 ** The MessageCode of this Message.
	 **/
	protected MessageCode messageCode = null;
	
	/**
	 ** The title of the message.
	 **/
	protected String messageTitle = null;
	
	/**
	 ** The content of the message.
	 **/
	protected String messageContent = null;
	
	/**
	 ** The title of the explanations.
	 **/
	protected String explanationTitle = null;
	
	/**
	 ** The content of the explanations.
	 **/
	protected String explanationContent = null;
	
	/**
	 ** The title of the action.
	 **/
	protected String actionTitle = null;
	
	/**
	 ** The content of the action.
	 **/
	protected String actionContent = null;
	
	/**
	 ** The helpID of this message.
	 **/
	protected String helpID = null;
	
	
	/**
	 ** Creates a(n empty) DefaultMessage.
	 **
	 ** @pre        true
	 ** @post       true
	 **/
	public DefaultMessage() {}

	
	/**
	 ** Creates a DefaultMessage from the given parameters.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      messageCode     the MessageCode of this Message.
	 ** @param      messageTitle    the title of the message.
	 ** @param      messageContent  the content of the message.
	 **/
	public DefaultMessage(MessageCode messageCode, String messageTitle, String messageContent) {
		
		this.messageCode = messageCode;
		this.messageTitle = messageTitle;
		this.messageContent = messageContent;
	}
	
	
	/**
	 ** Returns the MessageCode of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the MessageCode of the message.
	 **/
	public MessageCode getMessageCode() {
		return messageCode;
	}
	
	/**
	 ** Sets the MessageCode of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      messageCode  the MessageCode of the message.
	 **/
	public void setMessageCode(MessageCode messageCode) {
		this.messageCode = messageCode;
	}
	
	
	/**
	 ** Returns the title of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the message.
	 **/
	public String getMessageTitle() {
		return messageTitle;
	}
	
	/**
	 ** Sets the title of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      messageTitle  the title of the message.
	 **/
	public void setMessageTitle(String messageTitle) {
		this.messageTitle = messageTitle;
	}
	
	/**
	 ** Returns the content of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the content of the message.
	 **/
	public String getMessageContent() {
		return messageContent;
	}

	/**
	 ** Sets the content of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      messageContent  the content of the message.
	 **/
	public void setMessageContent(String messageContent) {
		this.messageContent = messageContent;
	}

	
	/**
	 ** Returns the title of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the explanation section.
	 **/
	public String getExplanationTitle() {
		return explanationTitle;
	}
	
	/**
	 ** Sets the title of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param     explanationTitle  the title of the explanation section.
	 **/
	public void setExplanationTitle(String explanationTitle) {
		this.explanationTitle = explanationTitle;
	}
	
	/**
	 ** Returns the content of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the content of the explanation section.
	 **/
	public String getExplanationContent() {
		return explanationContent;
	}
	
	/**
	 ** Sets the content of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param     explanationContent  the content of the explanation section.
	 **/
	public void setExplanationContent(String explanationContent) {
		this.explanationContent = explanationContent;
	}
	
	
	/**
	 ** Returns the title of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the action section.
	 **/
	public String getActionTitle() {
		return actionTitle;
	}
	
	/**
	 ** Sets the title of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      actionTitle  the title of the action section.
	 **/
	public void setActionTitle(String actionTitle) {
		this.actionTitle = actionTitle;
	}
	
	/**
	 ** Returns the content of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the content of the action section.
	 **/
	public String getActionContent() {
		return actionContent;
	}
	
	/**
	 ** Sets the content of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param     actionContent  the content of the action section.
	 **/
	public void setActionContent(String actionContent) {
		this.actionContent = actionContent;
	}
	
	/**
	 ** Returns the helpID of this message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the helpID of this message.
	 **/
	public String getHelpID() {
		return helpID;
	}
	
	/**
	 ** Sets the helpID of this message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param       helpID  the helpID of this message.
	 **/
	public void setHelpID(String helpID) {
		this.helpID = helpID;
	}
	
	/**
	 ** Sets the details of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      details  the details of the message.
	 **/
	public void setDetails(String details) {
		super.setDetails(details);
	}

	
	/**
	 ** Returns a String representation of the Message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     a String representation of the Message.
	 **/
	public String toString() {
		
		StringBuffer buffer = new StringBuffer("DefaultMessage[");
		buffer.append("messageCode=");
		buffer.append(getMessageCode());
		buffer.append(", messageTitle=");
		buffer.append(getMessageTitle());
		buffer.append(", messageContent=");
		buffer.append(getMessageContent());
		buffer.append(", explanationTitle=");
		buffer.append(getExplanationTitle());
		buffer.append(", explanationContent=");
		buffer.append(getExplanationContent());
		buffer.append(", actionTitle=");
		buffer.append(getActionTitle());
		buffer.append(", actionContent=");
		buffer.append(getActionContent());
		buffer.append(", helpID=");
		buffer.append(getHelpID());
		buffer.append("]");
		
		return buffer.toString();
	}

}

