/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/Message.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

// import list
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.ParserConfigurationException;

/**
 ** The Message interface defines the properties of a message.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public interface Message {
	
	
	/**
	 ** Returns the MessageCode of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the MessageCode of the message.
	 **/
	public MessageCode getMessageCode();
	
	
	/**
	 ** Returns the title of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the message.
	 **/
	public String getMessageTitle();
	
	/**
	 ** Returns the content of the message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the message to display to the user.
	 **/
	public String getMessageContent();
	
	
	/**
	 ** Returns the title of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the explanation section.
	 **/
	public String getExplanationTitle();
	
	/**
	 ** Returns the content of the explanation section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the explanation to display to the user.
	 **/
	public String getExplanationContent();
	
	
	/**
	 ** Returns the title of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the title of the action section.
	 **/
	public String getActionTitle();
	
	/**
	 ** Returns the content of the action section.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the action to display to the user.
	 **/
	public String getActionContent();
	
	/**
	 ** Returns the helpID of this message.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     the helpID of this message.
	 **/
	public String getHelpID();
	
	/**
	 ** Returns an XML representation of the message.
	 ** <code>Null</code> values are represented by omitting the corresponding Element.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @return     an XML representation of the message.
	 **
	 ** @throws     ParserConfigurationException if instantiation of a DocumentBuilder
	 **                                          failed (which is needed to create
	 **                                          the Document).
	 **
	 ** @see        MessageConstants
	 **/
	public Document toXML() throws ParserConfigurationException;
	
	
	/**
	 ** Returns an XML representation of the message where the given
	 ** <code>document</code> is used to create the Element(s).
	 ** <code>Null</code> values are represented by omitting the corresponding Element.
	 **
	 ** @pre        true
	 ** @post       true
	 **
	 ** @param      document  the Document that is used to create the Element(s).
	 **
	 ** @return     an XML representation of the message.
	 **
	 ** @see        MessageConstants
	 **/
	public Element toXML(Document document);
}

