/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/MessageConstants.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

// import list

/**
 ** This interface defines a set of common constants.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public interface MessageConstants {
	
	/**
	 ** String constant for the name of the <code>&lt;message&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String MESSAGE_TAG_NAME = "message";
	
	/**
	 ** String constant for the name of the <code>&lt;code&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String CODE_TAG_NAME = "code";
	
	/**
	 ** String constant for the name of the <code>&lt;title&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String TITLE_TAG_NAME = "title";
	
	/**
	 ** String constant for the name of the <code>&lt;content&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String CONTENT_TAG_NAME = "content";
	
	/**
	 ** String constant for the name of the <code>&lt;explanation&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String EXPLANATION_TAG_NAME = "explanation";
	
	/**
	 ** String constant for the name of the <code>&lt;action&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String ACTION_TAG_NAME = "action";
	
	/**
	 ** String constant for the name of the <code>&lt;help-id&gt;</code> tag
	 ** used by method {@link Message#toXML Message.toXML()}.
	 **/
	public static final String HELP_ID_TAG_NAME = "help-id";
	
	/**
	 ** String constant for the name of the <code>&lt;details&gt;</code> tag
	 ** used by method {@link DetailedMessage#toXML DetailedMessage.toXML()}.
	 **/
	public static final String DETAILS_TAG_NAME = "details";
	

	
	/**
	 ** The suffix of the title key in the properties file.
	 **/
	public static final String TITLE_SUFFIX = "_TITLE";
	
	/**
	 ** The suffix of the explanation key in the properties file.
	 **/
	public static final String EXPLANATION_SUFFIX = "_EXPLANATION";
	
	/**
	 ** The suffix of the explanation title key in the properties file.
	 **/
	public static final String EXPLANATION_TITLE_SUFFIX = "_EXPLANATION_TITLE";
	
	/**
	 ** The suffix of the action key in the properties file.
	 **/
	public static final String ACTION_SUFFIX = "_ACTION";
	
	/**
	 ** The suffix of the action title key in the properties file.
	 **/
	public static final String ACTION_TITLE_SUFFIX = "_ACTION_TITLE";
	
	/**
	 ** The suffix of the helpID key in the properties file.
	 **/
	public static final String HELP_ID_SUFFIX = "_HELP_ID";
	
	
}

