/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/resourceutilities/message/MessageRetrieveException.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.resourceutilities.message;

// import list
import java.util.ResourceBundle;

/**
 ** A MessageRetrieveException is thrown if the retrieval of the message content
 ** from a ResourceBundle failed.
 **
 ** @version $Revision: 1.4 $
 **
 ** @author rsk@softwareag.com
 **/
public class MessageRetrieveException extends RuntimeException {
    
    /**
     ** The Throwable that is the cause for this MessageRetrieveException.
     **/
    protected Throwable cause = null;
    
    /**
     ** The ResourceBundle from which the Message should have been retrieved.
     **/
    protected ResourceBundle resourceBundle = null;
    
    /**
     ** The ID (resource key) of the Message.
     **/
    protected String id = null;
    
    
    
    /**
     ** Creates a MessageRetrieveException from the given <code>resourceBundle</code>
     ** and <code>id</code>.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      resourceBundle  the ResourceBundle from which the Message
     **                             should have been retrieved.
     ** @param      id              the ID (resource key) of the Message.
     **/
    public MessageRetrieveException(ResourceBundle resourceBundle, String id) {
        this(resourceBundle, id, null, null);
    }
    
    /**
     ** Creates a MessageRetrieveException from the given <code>resourceBundle</code>
     ** <code>id</code> and <code>text</code>.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      resourceBundle  the ResourceBundle from which the Message
     **                             should have been retrieved.
     ** @param      id              the ID (resource key) of the Message.
     ** @param      text  the text of the Exception.
     **/
    public MessageRetrieveException(ResourceBundle resourceBundle, String id, String text) {
        this(resourceBundle, id, text, null);
    }
    
    /**
     ** Creates a MessageRetrieveException from the given <code>resourceBundle</code>
     ** <code>id</code> and <code>cause</code>.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      resourceBundle  the ResourceBundle from which the Message
     **                             should have been retrieved.
     ** @param      id              the ID (resource key) of the Message.
     ** @param      cause  the Throwable that is the cause for this
     **                    MessageRetrieveException.
     **/
    public MessageRetrieveException(ResourceBundle resourceBundle, String id, Throwable cause) {
        this(resourceBundle, id, null, cause);
    }
    
    /**
     ** Creates a MessageRetrieveException from the given <code>resourceBundle</code>
     ** <code>id</code>, <code>text</code> and <code>cause</code>.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      resourceBundle  the ResourceBundle from which the Message
     **                             should have been retrieved.
     ** @param      id              the ID (resource key) of the Message.
     ** @param      text            the text of the Exception.
     ** @param      cause           the Throwable that is the cause for this
     **                             MessageRetrieveException.
     **/
    public MessageRetrieveException(ResourceBundle resourceBundle, String id, String text, Throwable cause) {
        super(text);
        this.resourceBundle = resourceBundle;
        this.id = id;
        this.cause = cause;
    }
    
    
    
    
    /**
     ** Returns the ResourceBundle from which the Message should have been retrieved.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     the ResourceBundle from which the Message should have been retrieved.
     **/
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
    
    /**
     ** Returns the ID (resource key) of the Message.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     the ID (resource key) of the Message.
     **/
    public String getID() {
        return id;
    }
    
    /**
     ** Returns the Throwable that is the cause for this MessageRetrieveException.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     the Throwable that is the cause for this MessageRetrieveException.
     **/
    public Throwable getCause() {
        return cause;
    }
    
    /**
     ** Returns a String representation of this instance.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     a String representation of this instance.
     **/
    public String toString() {
        
        StringBuffer buffer = new StringBuffer("MessageRetrieveException[");
        buffer.append("resourceBundle=");
        buffer.append(getResourceBundle());
        buffer.append(", id=");
        buffer.append(getID());
        buffer.append(", message=");
        buffer.append(getMessage());
        buffer.append(", cause=");
        buffer.append(getCause());
        buffer.append("]");
        
        return buffer.toString();
    }
}

